/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.ItemHolder;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.drops.EquipSlot;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import org.bukkit.inventory.EquipmentSlot;

public class MechanicLinkItemBone
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final PlaceholderString slot;

    public MechanicLinkItemBone(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mythicLineConfig.getPlaceholderString(new String[]{"b", "bone"}, null, new String[0]);
        this.slot = mythicLineConfig.getPlaceholderString(new String[]{"s", "slot"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        ActiveModel activeModel = MythicUtils.getActiveModelOrNull(modeledEntity, string);
        if (activeModel == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String string2 = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string2 == null) {
            return SkillResult.INVALID_CONFIG;
        }
        ItemHolder itemHolder = (ItemHolder)activeModel.getItemHolderHandler().getBones().get(string2);
        if (itemHolder == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String string3 = MythicUtils.getOrNull(this.slot, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string3 == null) {
            itemHolder.setTrackedSlot(null);
            return SkillResult.SUCCESS;
        }
        EquipSlot equipSlot = EquipSlot.of((String)string3);
        itemHolder.setTrackedSlot(switch (equipSlot) {
            case EquipSlot.HEAD -> EquipmentSlot.HEAD;
            case EquipSlot.CHEST -> EquipmentSlot.CHEST;
            case EquipSlot.LEGS -> EquipmentSlot.LEGS;
            case EquipSlot.FEET -> EquipmentSlot.FEET;
            case EquipSlot.HAND -> EquipmentSlot.HAND;
            case EquipSlot.OFFHAND -> EquipmentSlot.OFF_HAND;
            case EquipSlot.NONE -> null;
            default -> throw new IncompatibleClassChangeError();
        });
        return SkillResult.SUCCESS;
    }
}

