/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicLockHead
implements ITargetedEntitySkill {
    private final MythicLineConfig config;
    private final PlaceholderString modelId;

    public MechanicLockHead(MythicLineConfig mythicLineConfig) {
        this.config = mythicLineConfig;
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        MythicUtils.executeOptModelId(modeledEntity, string, this::lock);
        return SkillResult.SUCCESS;
    }

    private void lock(ActiveModel activeModel) {
        boolean bl = this.config.getBoolean(new String[]{"lp", "lpitch", "lockpitch"}, activeModel.isLockPitch());
        boolean bl2 = this.config.getBoolean(new String[]{"ly", "lyaw", "lockyaw"}, activeModel.isLockYaw());
        activeModel.setLockPitch(bl);
        activeModel.setLockYaw(bl2);
    }
}

