/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.AnimationMode;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.Nameable;
import com.ticxo.modelengine.mythic.MythicUtils;
import com.ticxo.modelengine.mythic.utils.PlaceholderStringInstance;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderStringImpl;

public class MechanicModel
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString mode;
    private final PlaceholderString nametag;
    private final boolean hitbox;
    private final boolean remove;
    private final boolean killOwner;
    private final boolean invisible;
    private final boolean doDamageTint;
    private final boolean canDrive;
    private final boolean canRide;
    private final boolean lockPitch;
    private final boolean lockYaw;
    private final PlaceholderDouble stepHeight;
    private final PlaceholderInt viewRadius;

    public MechanicModel(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.hitbox = mythicLineConfig.getBoolean(new String[]{"h", "hitbox"}, true);
        this.remove = mythicLineConfig.getBoolean(new String[]{"r", "remove"}, false);
        this.killOwner = mythicLineConfig.getBoolean(new String[]{"ko", "killowner"}, false);
        this.invisible = mythicLineConfig.getBoolean(new String[]{"i", "invis", "invisible"}, true);
        this.doDamageTint = mythicLineConfig.getBoolean(new String[]{"d", "tint", "damagetint"}, true);
        this.nametag = mythicLineConfig.getPlaceholderString(new String[]{"n", "name", "nametag"}, null, new String[0]);
        this.canDrive = mythicLineConfig.getBoolean(new String[]{"drive"}, false);
        this.canRide = mythicLineConfig.getBoolean(new String[]{"ride"}, false);
        this.mode = mythicLineConfig.getPlaceholderString(new String[]{"mode"}, null, new String[0]);
        this.lockPitch = mythicLineConfig.getBoolean(new String[]{"lp", "lpitch", "lockpitch"}, false);
        this.lockYaw = mythicLineConfig.getBoolean(new String[]{"ly", "lyaw", "lockyaw"}, false);
        this.stepHeight = mythicLineConfig.getPlaceholderDouble(new String[]{"s", "step"}, 0.5, new String[0]);
        this.viewRadius = mythicLineConfig.getPlaceholderInteger(new String[]{"rad", "radius"}, 0, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        if (this.remove) {
            return this.removeModel(skillMetadata, abstractEntity);
        }
        return this.addModel(skillMetadata, abstractEntity);
    }

    private SkillResult removeModel(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string == null) {
            for (ActiveModel activeModel : modeledEntity.getModels().values()) {
                activeModel.destroy();
            }
        } else {
            ActiveModel activeModel = modeledEntity.removeModel(string);
            if (activeModel == null) {
                return SkillResult.CONDITION_FAILED;
            }
            activeModel.destroy();
        }
        if (this.killOwner) {
            abstractEntity.remove();
            return SkillResult.SUCCESS;
        }
        if (modeledEntity.getModels().isEmpty()) {
            modeledEntity.setBaseEntityVisible(true);
            ModelEngineAPI.removeModeledEntity(abstractEntity.getUniqueId());
        } else {
            modeledEntity.setBaseEntityVisible(!this.invisible);
        }
        return SkillResult.SUCCESS;
    }

    private SkillResult addModel(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        ModelBlueprint modelBlueprint = MythicUtils.getBlueprintOrNull(string);
        if (modelBlueprint == null) {
            return SkillResult.INVALID_CONFIG;
        }
        double d = this.stepHeight.get((PlaceholderMeta)skillMetadata, abstractEntity);
        int n = this.viewRadius.get((PlaceholderMeta)skillMetadata, abstractEntity);
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            modeledEntity = ModelEngineAPI.createModeledEntity(abstractEntity.getBukkitEntity());
        }
        ModeledEntity modeledEntity2 = modeledEntity;
        modeledEntity2.queuePostInitTask(() -> {
            modeledEntity2.setBaseEntityVisible(!this.invisible);
            modeledEntity2.setStepHeight(d);
            modeledEntity2.getMountManager().setCanSteer(this.canDrive);
            modeledEntity2.getMountManager().setCanRide(this.canRide);
            if (n > 0) {
                modeledEntity2.getRangeManager().setRenderDistance(n);
            }
            if (modeledEntity2.getModel(string) == null) {
                Nameable nameable;
                ActiveModel activeModel = ModelEngineAPI.createActiveModel(modelBlueprint);
                activeModel.setCanHurt(this.doDamageTint);
                activeModel.setLockPitch(this.lockPitch);
                activeModel.setLockYaw(this.lockYaw);
                String string2 = MythicUtils.getOrNull(this.mode, (PlaceholderMeta)skillMetadata, abstractEntity);
                if (string2 != null) {
                    activeModel.setAnimationMode(AnimationMode.get(string2));
                }
                modeledEntity2.addModel(activeModel, this.hitbox);
                String string3 = MythicUtils.getOrNull(this.nametag, (PlaceholderMeta)skillMetadata, abstractEntity);
                if (string3 != null && (nameable = (Nameable)activeModel.getNametagHandler().getBones().get(string3)) != null) {
                    nameable.setCustomName(new PlaceholderStringInstance((PlaceholderString)new PlaceholderStringImpl("<target.name>"), skillMetadata, abstractEntity));
                    nameable.setCustomNameVisible(true);
                }
            }
        });
        return SkillResult.SUCCESS;
    }
}

