/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.handler.RendererHandler;
import com.ticxo.modelengine.api.nms.entity.fake.BoneRenderer;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Set;

public class MechanicRemapModel
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString newModelId;
    private final PlaceholderString map;

    public MechanicRemapModel(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.newModelId = mythicLineConfig.getPlaceholderString(new String[]{"n", "nid", "newmodel", "newmodelid"}, null, new String[0]);
        this.map = mythicLineConfig.getPlaceholderString(new String[]{"map"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        ActiveModel activeModel = MythicUtils.getActiveModelOrNull(modeledEntity, string);
        if (activeModel == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String string2 = MythicUtils.getOrNull(this.newModelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        ModelBlueprint modelBlueprint = MythicUtils.getBlueprintOrNull(string2);
        if (modelBlueprint == null) {
            return SkillResult.INVALID_CONFIG;
        }
        if (this.map != null) {
            String string3 = MythicUtils.getOrNull(this.map, (PlaceholderMeta)skillMetadata, abstractEntity);
            ModelBlueprint modelBlueprint2 = MythicUtils.getBlueprintOrNull(string3);
            if (modelBlueprint2 == null) {
                return SkillResult.INVALID_CONFIG;
            }
            RendererHandler rendererHandler = activeModel.getRendererHandler();
            Set<String> set = modelBlueprint2.getFlatMap().size() < rendererHandler.getFakeEntity().size() ? modelBlueprint2.getFlatMap().keySet() : rendererHandler.getFakeEntity().keySet();
            for (String string4 : set) {
                BoneRenderer boneRenderer;
                Integer n = modelBlueprint.getItemIds().get(string4);
                if (n == null || (boneRenderer = (BoneRenderer)rendererHandler.getFakeEntity().get(string4)) == null) continue;
                boneRenderer.setData(n);
            }
        } else {
            RendererHandler rendererHandler = activeModel.getRendererHandler();
            Set<String> set = modelBlueprint.getItemIds().size() < rendererHandler.getFakeEntity().size() ? modelBlueprint.getItemIds().keySet() : rendererHandler.getFakeEntity().keySet();
            for (String string5 : set) {
                BoneRenderer boneRenderer;
                Integer n = modelBlueprint.getItemIds().get(string5);
                if (n == null || (boneRenderer = (BoneRenderer)rendererHandler.getFakeEntity().get(string5)) == null) continue;
                boneRenderer.setData(n);
            }
        }
        return SkillResult.SUCCESS;
    }
}

