/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.ItemHolder;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MechanicSetItemModel
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final PlaceholderString item;

    public MechanicSetItemModel(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mythicLineConfig.getPlaceholderString(new String[]{"b", "bone"}, null, new String[0]);
        this.item = mythicLineConfig.getPlaceholderString(new String[]{"i", "item"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        ActiveModel activeModel = MythicUtils.getActiveModelOrNull(modeledEntity, string);
        if (activeModel == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String string2 = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string2 == null) {
            return SkillResult.INVALID_CONFIG;
        }
        ItemHolder itemHolder = (ItemHolder)activeModel.getItemHolderHandler().getBones().get(string2);
        if (itemHolder == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String string3 = MythicUtils.getOrNull(this.item, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string3 == null) {
            itemHolder.setItemStack(new ItemStack(Material.AIR));
            return SkillResult.SUCCESS;
        }
        Optional optional = MythicBukkit.inst().getItemManager().getItem(string3);
        if (optional.isPresent()) {
            itemHolder.setItemStack(BukkitAdapter.adapt((AbstractItemStack)((MythicItem)optional.get()).generateItemStack(1)));
            return SkillResult.SUCCESS;
        }
        Material material = Material.getMaterial((String)string3.toUpperCase(Locale.ENGLISH));
        if (material == null) {
            return SkillResult.INVALID_CONFIG;
        }
        itemHolder.setItemStack(new ItemStack(material));
        return SkillResult.SUCCESS;
    }
}

