/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3;

import com.ticxo.modelengine.nms.v1_16_R3.entity.fake.FakeAreaEffectCloud;
import com.ticxo.modelengine.nms.v1_16_R3.network.NetworkUtils;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketDataSerializer;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntity;
import org.bukkit.util.Vector;

public enum PacketDataFixer {
    CLOUD_RIDE_OFFSET_SPAWN(n -> n >= 764, (fakeAreaEffectCloud, packet) -> {
        if (!(packet instanceof PacketPlayOutSpawnEntity)) {
            return packet;
        }
        Vector vector = fakeAreaEffectCloud.getLocation();
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(fakeAreaEffectCloud.getEntityId());
        packetDataSerializer.a(fakeAreaEffectCloud.getUuid());
        packetDataSerializer.d(IRegistry.ENTITY_TYPE.a((Object)EntityTypes.AREA_EFFECT_CLOUD));
        packetDataSerializer.writeDouble(vector.getX() + fakeAreaEffectCloud.getLastOffset().getX());
        packetDataSerializer.writeDouble(vector.getY() + fakeAreaEffectCloud.getLastOffset().getY() + -0.5);
        packetDataSerializer.writeDouble(vector.getZ() + fakeAreaEffectCloud.getLastOffset().getZ());
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeInt(0);
        packetDataSerializer.writeShort(0);
        packetDataSerializer.writeShort(0);
        packetDataSerializer.writeShort(0);
        return NetworkUtils.writeData(new PacketPlayOutSpawnEntity(), packetDataSerializer);
    }),
    CLOUD_RIDE_OFFSET_UPDATE(n -> n >= 764, (fakeAreaEffectCloud, packet) -> {
        if (!(packet instanceof PacketPlayOutEntityTeleport)) {
            return packet;
        }
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        Vector vector = fakeAreaEffectCloud.getLocation();
        packetDataSerializer.d(fakeAreaEffectCloud.getEntityId());
        packetDataSerializer.writeDouble(vector.getX() + fakeAreaEffectCloud.getLastOffset().getX());
        packetDataSerializer.writeDouble(vector.getY() + fakeAreaEffectCloud.getLastOffset().getY() + -0.5);
        packetDataSerializer.writeDouble(vector.getZ() + fakeAreaEffectCloud.getLastOffset().getZ());
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeBoolean(false);
        return NetworkUtils.writeData(new PacketPlayOutEntityTeleport(), packetDataSerializer);
    });

    final Predicate<Integer> requirements;
    final BiFunction<FakeAreaEffectCloud, Packet<?>, Packet<?>> function;

    private PacketDataFixer(Predicate<Integer> predicate, BiFunction<FakeAreaEffectCloud, Packet<?>, Packet<?>> biFunction) {
        this.requirements = predicate;
        this.function = biFunction;
    }

    public Packet<?> fix(int n, FakeAreaEffectCloud fakeAreaEffectCloud, Packet<?> packet) {
        if (this.requirements.test(n)) {
            return this.function.apply(fakeAreaEffectCloud, packet);
        }
        return packet;
    }
}

