/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_18_R1.network;

import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.entity.Dummy;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.Mountable;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.api.model.mananger.ModelTicker;
import com.ticxo.modelengine.api.model.mananger.VFXTicker;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.api.mount.controller.MountController;
import com.ticxo.modelengine.api.nms.entity.fake.BoneRenderer;
import com.ticxo.modelengine.api.nms.world.IDamageSource;
import com.ticxo.modelengine.nms.v1_18_R1.network.NetworkUtils;
import com.ticxo.modelengine.nms.v1_18_R1.network.PacketInterceptor;
import com.ticxo.modelengine.nms.v1_18_R1.network.interact.ServerboundInteractPacketWrapper;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.Vector;

public class ModelEngineChannelHandler
extends ChannelDuplexHandler {
    private final Player bukkit;
    private final EntityPlayer player;
    private final ModelTicker ticker;
    private final VFXTicker vfxTicker;
    private final PacketInterceptor writeInterceptors;
    private final PacketInterceptor readInterceptors;

    public ModelEngineChannelHandler(Player player) {
        this.bukkit = player;
        this.player = ((CraftPlayer)player).getHandle();
        this.ticker = ModelEngineAPI.getModelTicker();
        this.vfxTicker = ModelEngineAPI.getVFXTicker();
        this.writeInterceptors = new PacketInterceptor().register(PacketPlayOutSpawnEntity.class, this::handleAddEntity).register(PacketPlayOutSpawnEntityLiving.class, this::handleAddMob).register(PacketPlayOutNamedEntitySpawn.class, this::handleAddPlayer).register(PacketPlayOutEntityDestroy.class, this::handleRemoveEntities).register(PacketPlayOutScoreboardTeam.class, this::handleSetPlayerTeam).register(PacketPlayOutEntityMetadata.class, this::handleSetEntityData).registerPost(PacketPlayOutRespawn.class, this::handleRespawn).registerPost(PacketPlayOutPosition.class, this::handlePlayerPosition).registerPost(PacketPlayOutSpawnEntity.class, this::handlePostAddEntity).registerPost(PacketPlayOutSpawnEntityLiving.class, this::handlePostAddMob).registerPost(PacketPlayOutNamedEntitySpawn.class, this::handlePostAddPlayer);
        this.readInterceptors = new PacketInterceptor().register(PacketPlayInSteerVehicle.class, this::handlePlayerInput).register(PacketPlayInUseEntity.class, this::handleInteract);
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object packet, ChannelPromise channelPromise) {
        Packet<?> packet2 = packet;
        if (!(packet2 instanceof Packet)) {
            super.write(channelHandlerContext, (Object)packet, channelPromise);
            return;
        }
        Packet packet3 = (Packet)packet2;
        packet = this.writeInterceptors.accept(packet3);
        if (packet == null) {
            return;
        }
        super.write(channelHandlerContext, packet, channelPromise);
        this.writeInterceptors.acceptPost(packet3);
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object packet) {
        Packet<?> packet2 = packet;
        if (!(packet2 instanceof Packet)) {
            super.channelRead(channelHandlerContext, (Object)packet);
            return;
        }
        Packet packet3 = (Packet)packet2;
        packet = this.readInterceptors.accept(packet3);
        if (packet == null) {
            return;
        }
        super.channelRead(channelHandlerContext, packet);
        this.readInterceptors.acceptPost(packet3);
    }

    private boolean showModel(int n) {
        VFX vFX;
        boolean bl = false;
        ModeledEntity modeledEntity = this.ticker.getModeledEntity(n);
        if (modeledEntity != null) {
            if (modeledEntity.getBase().isNpc()) {
                modeledEntity.getRangeManager().addTrackedPlayer(this.bukkit);
            }
            modeledEntity.showToPlayer(this.bukkit);
            boolean bl2 = bl = !modeledEntity.isBaseEntityVisible();
        }
        if ((vFX = this.vfxTicker.getVFX(n)) != null) {
            vFX.showToPlayer(this.bukkit);
            bl |= !vFX.isBaseEntityVisible();
        }
        return bl;
    }

    private boolean showModel(UUID uUID) {
        VFX vFX;
        boolean bl = false;
        ModeledEntity modeledEntity = this.ticker.getModeledEntity(uUID);
        if (modeledEntity != null) {
            if (modeledEntity.getBase().isNpc()) {
                modeledEntity.getRangeManager().addTrackedPlayer(this.bukkit);
            }
            modeledEntity.showToPlayer(this.bukkit);
            boolean bl2 = bl = !modeledEntity.isBaseEntityVisible();
        }
        if ((vFX = this.vfxTicker.getVFX(uUID)) != null) {
            vFX.showToPlayer(this.bukkit);
            bl |= !vFX.isBaseEntityVisible();
        }
        return bl;
    }

    private void hideModel(int n) {
        VFX vFX;
        ModeledEntity modeledEntity = this.ticker.getModeledEntity(n);
        if (modeledEntity != null && (!modeledEntity.getBase().isDead() || modeledEntity.getBase().isDead() && modeledEntity.getAnimationState(false))) {
            if (modeledEntity.getBase().isNpc()) {
                modeledEntity.getRangeManager().removeTrackedPlayer(this.bukkit);
            }
            modeledEntity.hideFromPlayer(this.bukkit);
        }
        if ((vFX = this.vfxTicker.getVFX(n)) != null) {
            vFX.hideFromPlayer(this.bukkit);
        }
    }

    private Packet<?> handleAddEntity(PacketPlayOutSpawnEntity packetPlayOutSpawnEntity) {
        return this.showModel(packetPlayOutSpawnEntity.b()) ? null : packetPlayOutSpawnEntity;
    }

    private Packet<?> handleAddMob(PacketPlayOutSpawnEntityLiving packetPlayOutSpawnEntityLiving) {
        return this.showModel(packetPlayOutSpawnEntityLiving.b()) ? null : packetPlayOutSpawnEntityLiving;
    }

    private Packet<?> handleAddPlayer(PacketPlayOutNamedEntitySpawn packetPlayOutNamedEntitySpawn) {
        return this.showModel(packetPlayOutNamedEntitySpawn.c()) ? null : packetPlayOutNamedEntitySpawn;
    }

    private Packet<?> handleRemoveEntities(PacketPlayOutEntityDestroy packetPlayOutEntityDestroy) {
        IntListIterator intListIterator = packetPlayOutEntityDestroy.b().iterator();
        while (intListIterator.hasNext()) {
            int n = (Integer)intListIterator.next();
            this.hideModel(n);
        }
        return packetPlayOutEntityDestroy;
    }

    private Packet<?> handleSetPlayerTeam(PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam) {
        Object object2;
        if (packetPlayOutScoreboardTeam.e() == null || packetPlayOutScoreboardTeam.e().isEmpty()) {
            return packetPlayOutScoreboardTeam;
        }
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetPlayOutScoreboardTeam.a(packetDataSerializer);
        String string = packetDataSerializer.p();
        byte by = packetDataSerializer.readByte();
        if (by == 1 || by == 2) {
            return packetPlayOutScoreboardTeam;
        }
        Set set = Sets.newConcurrentHashSet();
        for (Object object2 : packetPlayOutScoreboardTeam.e()) {
            UUID uUID;
            try {
                uUID = UUID.fromString((String)object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Player player = Bukkit.getPlayerExact((String)object2);
                if (player == null) continue;
                uUID = player.getUniqueId();
            }
            ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(uUID);
            if (modeledEntity == null) continue;
            for (ActiveModel activeModel : modeledEntity.getModels().values()) {
                for (BoneRenderer boneRenderer : activeModel.getRendererHandler().getFakeEntity().values()) {
                    set.add(boneRenderer.getRendererUUID().toString());
                }
            }
        }
        PacketPlayOutScoreboardTeam.b b2 = by == 0 ? new PacketPlayOutScoreboardTeam.b(packetDataSerializer) : null;
        object2 = packetDataSerializer.a(PacketDataSerializer::p);
        object2.addAll(set);
        packetDataSerializer.a(string);
        packetDataSerializer.writeByte((int)by);
        if (by == 0) {
            b2.a(packetDataSerializer);
        }
        packetDataSerializer.a((Collection)object2, PacketDataSerializer::a);
        return new PacketPlayOutScoreboardTeam(packetDataSerializer);
    }

    private Packet<?> handleSetEntityData(PacketPlayOutEntityMetadata packetPlayOutEntityMetadata) {
        if (packetPlayOutEntityMetadata.c() != this.player.ae()) {
            return packetPlayOutEntityMetadata;
        }
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(this.player.cm());
        if (modeledEntity == null || modeledEntity.isBaseEntityVisible()) {
            return packetPlayOutEntityMetadata;
        }
        ModelEngineAPI.getEntityHandler().setSelfFakeInvisible(this.bukkit, true);
        return null;
    }

    private void handleRespawn(PacketPlayOutRespawn packetPlayOutRespawn) {
        ModelEngineAPI.getEntityHandler().getDynamicHitbox().spawn(this.bukkit);
    }

    private void handlePlayerPosition(PacketPlayOutPosition packetPlayOutPosition) {
        ModelEngineAPI.getEntityHandler().getDynamicHitbox().spawn(this.bukkit);
    }

    private void handlePostAddEntity(PacketPlayOutSpawnEntity packetPlayOutSpawnEntity) {
        Mountable mountable;
        UUID uUID = packetPlayOutSpawnEntity.c();
        ModeledEntity modeledEntity = ModelEngineAPI.getMountPair(uUID);
        if (modeledEntity != null && (mountable = modeledEntity.getMountManager().getMountedBone(uUID)) != null) {
            mountable.getMountPoint().spawn(this.bukkit);
        }
    }

    private void handlePostAddMob(PacketPlayOutSpawnEntityLiving packetPlayOutSpawnEntityLiving) {
        Mountable mountable;
        UUID uUID = packetPlayOutSpawnEntityLiving.c();
        ModeledEntity modeledEntity = ModelEngineAPI.getMountPair(uUID);
        if (modeledEntity != null && (mountable = modeledEntity.getMountManager().getMountedBone(uUID)) != null) {
            mountable.getMountPoint().spawn(this.bukkit);
        }
    }

    private void handlePostAddPlayer(PacketPlayOutNamedEntitySpawn packetPlayOutNamedEntitySpawn) {
        Mountable mountable;
        UUID uUID = packetPlayOutNamedEntitySpawn.c();
        ModeledEntity modeledEntity = ModelEngineAPI.getMountPair(uUID);
        if (modeledEntity != null && (mountable = modeledEntity.getMountManager().getMountedBone(uUID)) != null) {
            mountable.getMountPoint().spawn(this.bukkit);
        }
    }

    private Packet<?> handlePlayerInput(PacketPlayInSteerVehicle packetPlayInSteerVehicle) {
        MountController mountController = ModelEngineAPI.getPlayerMountController(this.player.cm());
        if (mountController != null) {
            MountController.MountInput mountInput = new MountController.MountInput(packetPlayInSteerVehicle.b(), packetPlayInSteerVehicle.c(), packetPlayInSteerVehicle.d(), packetPlayInSteerVehicle.e());
            mountController.setInput(mountInput);
        }
        return packetPlayInSteerVehicle;
    }

    private Packet<?> handleInteract(PacketPlayInUseEntity packetPlayInUseEntity) {
        Object object;
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetPlayInUseEntity.a(packetDataSerializer);
        int n = packetDataSerializer.j();
        UUID uUID = ModelEngineAPI.getInteractionTicker().getModelRelay(n);
        if (uUID != null) {
            object = this.ticker.getModeledEntity(uUID);
            if (object != null) {
                BaseEntity<?> baseEntity = object.getBase();
                if (baseEntity instanceof Dummy) {
                    Dummy dummy = (Dummy)baseEntity;
                    int n2 = packetDataSerializer.j();
                    switch (n2) {
                        case 0: {
                            int n3 = packetDataSerializer.j();
                            dummy.onInteract(this.bukkit, n3 == 0 ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
                            break;
                        }
                        case 1: {
                            dummy.onHurt(IDamageSource.UNKNOWN, 0.0f);
                            break;
                        }
                        case 2: {
                            Vector vector = new Vector(packetDataSerializer.readFloat(), packetDataSerializer.readFloat(), packetDataSerializer.readFloat());
                            int n4 = packetDataSerializer.j();
                            dummy.onInteractAt(this.bukkit, n4 == 0 ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND, vector);
                        }
                    }
                    return null;
                }
                return new ServerboundInteractPacketWrapper(object.getBase().getEntityId(), packetPlayInUseEntity);
            }
            SubHitbox subHitbox = this.ticker.getSubHitboxBone(uUID);
            if (subHitbox != null) {
                return new ServerboundInteractPacketWrapper(subHitbox.getSubHitboxEntity().getEntityId(), packetPlayInUseEntity);
            }
        }
        if ((object = ModelEngineAPI.getInteractionTicker().getRelayedId(this.player.ae())) != null) {
            return new ServerboundInteractPacketWrapper((Integer)object, packetPlayInUseEntity);
        }
        return packetPlayInUseEntity;
    }
}

