/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_20_R3.entity.fake.hitbox;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.generator.Hitbox;
import com.ticxo.modelengine.api.nms.entity.hitbox.ModelHitbox;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.nms.v1_20_R3.entity.fake.FakeSlime;
import com.ticxo.modelengine.nms.v1_20_R3.network.NetworkUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class ModelHitboxImpl
implements ModelHitbox {
    private final BaseEntity<?> baseEntity;
    private final UUID uuid;
    private final Supplier<Hitbox> hitboxSupplier;
    private final Supplier<Vector> locationSupplier;
    private RangeManager rangeManager = RangeManager.EMPTY;
    private final List<FakeSlime> hitboxStack = new ArrayList<FakeSlime>();
    private final List<Packet<?>> stackOrder = new ArrayList();
    private PacketPlayOutEntityDestroy despawnPacket;

    public ModelHitboxImpl(BaseEntity<?> baseEntity) {
        this(baseEntity, baseEntity.getUniqueId(), baseEntity::getHitbox, () -> baseEntity.getLocation().toVector());
    }

    @Override
    public synchronized void refresh() {
        this.hitboxStack.clear();
        this.stackOrder.clear();
        this.rangeManager = this.baseEntity.getRangeManager();
        Hitbox hitbox = this.hitboxSupplier.get();
        Vector vector = this.locationSupplier.get();
        int n = Math.max(TMath.biasRound(hitbox.getWidth() / 0.5202, 0.2), 1);
        FakeSlime fakeSlime = new FakeSlime(vector.getX(), vector.getY(), vector.getZ());
        ModelEngineAPI.getInteractionTicker().setModelRelay(fakeSlime.getEntityId(), this.uuid);
        fakeSlime.setSize(n);
        this.hitboxStack.add(fakeSlime);
        double d = 0.5202 * (double)n;
        double d2 = d * 0.75;
        int n2 = TMath.biasRound((hitbox.getHeight() - d) / d2, 0.2);
        for (int i = 0; i < n2; ++i) {
            FakeSlime fakeSlime2 = new FakeSlime(vector.getX(), vector.getY(), vector.getZ());
            ModelEngineAPI.getInteractionTicker().setModelRelay(fakeSlime2.getEntityId(), this.uuid);
            fakeSlime2.setSize(n);
            this.stackOrder.add((Packet<?>)this.hitboxStack.get(this.hitboxStack.size() - 1).addPassenger(fakeSlime2.getEntityId()));
            this.hitboxStack.add(fakeSlime2);
        }
        int[] nArray = new int[this.hitboxStack.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.hitboxStack.get(i).getEntityId();
        }
        this.despawnPacket = new PacketPlayOutEntityDestroy(nArray);
    }

    @Override
    public synchronized void spawn() {
        ArrayList arrayList = new ArrayList();
        Vector vector = this.locationSupplier.get();
        for (FakeSlime fakeSlime : this.hitboxStack) {
            fakeSlime.setLocation(vector.getX(), vector.getY(), vector.getZ());
            arrayList.add((Packet<?>)fakeSlime.spawn());
            arrayList.add((Packet<?>)fakeSlime.meta());
        }
        arrayList.addAll(this.stackOrder);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), arrayList);
    }

    @Override
    public synchronized void spawn(Player player) {
        ArrayList arrayList = new ArrayList();
        Vector vector = this.locationSupplier.get();
        for (FakeSlime fakeSlime : this.hitboxStack) {
            fakeSlime.setLocation(vector.getX(), vector.getY(), vector.getZ());
            arrayList.add((Packet<?>)fakeSlime.spawn());
            arrayList.add((Packet<?>)fakeSlime.meta());
        }
        arrayList.addAll(this.stackOrder);
        NetworkUtils.send(player, arrayList);
    }

    @Override
    public synchronized void despawn() {
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{this.despawnPacket});
    }

    @Override
    public synchronized void despawn(Player player) {
        NetworkUtils.send(player, new Packet[]{this.despawnPacket});
    }

    @Override
    public synchronized void update() {
        if (this.hitboxStack.isEmpty()) {
            return;
        }
        FakeSlime fakeSlime = this.hitboxStack.get(0);
        PacketPlayOutEntityTeleport packetPlayOutEntityTeleport = fakeSlime.updatePositionCalibrated(this.locationSupplier.get());
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityTeleport});
    }

    @Override
    public void removeInteraction() {
        this.hitboxStack.forEach(fakeSlime -> ModelEngineAPI.getInteractionTicker().removeModelRelay(fakeSlime.getEntityId()));
    }

    public ModelHitboxImpl(BaseEntity<?> baseEntity, UUID uUID, Supplier<Hitbox> supplier, Supplier<Vector> supplier2) {
        this.baseEntity = baseEntity;
        this.uuid = uUID;
        this.hitboxSupplier = supplier;
        this.locationSupplier = supplier2;
    }

    @Override
    public BaseEntity<?> getBaseEntity() {
        return this.baseEntity;
    }
}

