/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_20_R3.entity.fake.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.BaseItemEnum;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.api.nms.entity.fake.FakeEntity;
import com.ticxo.modelengine.api.nms.entity.fake.VFXRenderer;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.nms.v1_20_R3.PacketDataFixer;
import com.ticxo.modelengine.nms.v1_20_R3.entity.fake.FakeAreaEffectCloud;
import com.ticxo.modelengine.nms.v1_20_R3.entity.fake.FakeArmorStand;
import com.ticxo.modelengine.nms.v1_20_R3.network.NetworkUtils;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class VFXRendererImpl
implements VFXRenderer {
    private static final ItemStack empty = new ItemStack(Material.AIR);
    private final VFX vfx;
    private final RangeManager rangeManager;
    private final FakeAreaEffectCloud cloud;
    private final FakeArmorStand armorStand;
    private ItemStack item;
    private boolean isItemDirty;
    private Color color;
    private boolean isEnchant;
    private boolean isModelVisible = true;

    public VFXRendererImpl(VFX vFX) {
        this.vfx = vFX;
        this.rangeManager = vFX.getRangeManager();
        Vector vector = vFX.getPosition();
        boolean bl = vFX.isSmall();
        this.cloud = new FakeAreaEffectCloud(vector.getX(), vector.getY(), vector.getZ());
        this.cloud.setSmall(bl);
        this.cloud.setDisplay(FakeEntity.DisplaySlot.HEAD);
        this.armorStand = new FakeArmorStand(vector.getX(), vector.getY(), vector.getZ());
        this.armorStand.setRotation(vFX.getRotation());
        this.armorStand.setInvisible(true);
        this.armorStand.setSmall(bl);
        this.armorStand.setDisplay(FakeEntity.DisplaySlot.HEAD);
    }

    @Override
    public void initialize() {
        Vector vector = this.vfx.getPosition();
        this.cloud.setLocation(vector.getX(), vector.getY(), vector.getZ());
        this.armorStand.setLocation(vector.getX(), vector.getY(), vector.getZ());
        this.item = ModelEngineAPI.api.getGenerator().getBaseItemType().create();
        this.setColor(this.vfx.getColor());
        this.setData(this.vfx.getData());
        this.setEnchant(this.vfx.isEnchant());
        this.setModelVisible(this.vfx.isVisible());
    }

    @Override
    public void spawn() {
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = this.cloud.spawn();
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.cloud.meta();
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity2 = this.armorStand.spawn(this.vfx.getYaw());
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata2 = this.armorStand.updateMeta(true);
        PacketPlayOutMount packetPlayOutMount = this.cloud.addPassengers(this.armorStand.getEntityId());
        NetworkUtils.sendProtocolDependant(this.rangeManager.getPlayerInRange(), packetPlayOutSpawnEntity, new PacketDataFixer[]{PacketDataFixer.CLOUD_RIDE_OFFSET_SPAWN});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityMetadata, packetPlayOutSpawnEntity2, packetPlayOutEntityMetadata2, packetPlayOutMount});
        ModelEngineAPI.getModelTicker().queueTask(() -> NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{this.armorStand.updateEquipment(this.isModelVisible ? this.item : empty)}));
    }

    @Override
    public void spawn(Player player) {
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = this.cloud.spawn();
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.cloud.meta();
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity2 = this.armorStand.spawn(this.vfx.getYaw());
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata2 = this.armorStand.updateMeta(true);
        PacketPlayOutMount packetPlayOutMount = this.cloud.addPassengers(this.armorStand.getEntityId());
        NetworkUtils.sendProtocolDependant(player, packetPlayOutSpawnEntity, new PacketDataFixer[]{PacketDataFixer.CLOUD_RIDE_OFFSET_SPAWN});
        NetworkUtils.send(player, new Packet[]{packetPlayOutEntityMetadata, packetPlayOutSpawnEntity2, packetPlayOutEntityMetadata2, packetPlayOutMount});
        ModelEngineAPI.getModelTicker().queueTask(() -> NetworkUtils.send(player, new Packet[]{this.armorStand.updateEquipment(this.isModelVisible ? this.item : empty)}));
    }

    @Override
    public void despawn() {
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.cloud.getEntityId(), this.armorStand.getEntityId()});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityDestroy});
    }

    @Override
    public void despawn(Player player) {
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.cloud.getEntityId(), this.armorStand.getEntityId()});
        NetworkUtils.send(player, new Packet[]{packetPlayOutEntityDestroy});
    }

    @Override
    public void update() {
        this.armorStand.setRotation(this.vfx.getRotation());
        this.armorStand.getLocation().zero().add(this.vfx.getPosition());
        PacketPlayOutEntityTeleport packetPlayOutEntityTeleport = this.cloud.updatePosition(this.vfx.getPosition());
        PacketPlayOutEntity.PacketPlayOutEntityLook packetPlayOutEntityLook = this.armorStand.updateYaw(this.vfx.getYaw(), false);
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.armorStand.updateMeta(false);
        PacketPlayOutEntityEquipment packetPlayOutEntityEquipment = null;
        if (this.isItemDirty) {
            packetPlayOutEntityEquipment = this.armorStand.updateEquipment(this.isModelVisible ? this.item : empty);
            this.isItemDirty = false;
        }
        NetworkUtils.sendProtocolDependant(this.rangeManager.getPlayerInRange(), packetPlayOutEntityTeleport, new PacketDataFixer[]{PacketDataFixer.CLOUD_RIDE_OFFSET_UPDATE});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityLook, packetPlayOutEntityMetadata, packetPlayOutEntityEquipment});
    }

    @Override
    public void updateModel() {
        PacketPlayOutEntityEquipment packetPlayOutEntityEquipment = this.armorStand.updateEquipment(this.isModelVisible ? this.item : empty);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityEquipment});
    }

    @Override
    public void setSmall(boolean bl) {
        this.armorStand.setSmall(bl);
        this.cloud.setSmall(bl);
    }

    @Override
    public void setModel(ItemStack itemStack) {
        this.item = itemStack;
        this.isItemDirty = true;
    }

    @Override
    public void setModelVisible(boolean bl) {
        this.isModelVisible = bl;
        this.isItemDirty = true;
    }

    @Override
    public void setGlowing(boolean bl) {
        this.armorStand.setGlowing(bl);
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.armorStand.updateMeta(false);
        if (packetPlayOutEntityMetadata == null) {
            return;
        }
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityMetadata});
    }

    @Override
    public void setColor(Color color) {
        if (color.equals((Object)this.color)) {
            return;
        }
        this.color = color;
        BaseItemEnum baseItemEnum = ModelEngineAPI.api.getGenerator().getBaseItemType();
        ItemMeta itemMeta = this.item.getItemMeta();
        baseItemEnum.color(itemMeta, color);
        this.item.setItemMeta(itemMeta);
        this.isItemDirty = true;
    }

    @Override
    public void setEnchant(boolean bl) {
        if (this.isEnchant == bl) {
            return;
        }
        this.isEnchant = bl;
        if (bl) {
            this.item.addUnsafeEnchantment(Enchantment.VANISHING_CURSE, 1);
        } else {
            this.item.removeEnchantment(Enchantment.VANISHING_CURSE);
        }
        this.isItemDirty = true;
    }

    @Override
    public void setData(int n) {
        ItemMeta itemMeta = this.item.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        itemMeta.setCustomModelData(Integer.valueOf(n));
        this.item.setItemMeta(itemMeta);
        this.isItemDirty = true;
    }

    @Override
    public void createRealRenderer() {
        this.armorStand.createRealRenderer(this.vfx.getBase().getWorld(), this.isModelVisible ? this.item : empty);
    }

    @Override
    public UUID getRendererUUID() {
        return this.armorStand.getUuid();
    }

    public FakeAreaEffectCloud getCloud() {
        return this.cloud;
    }

    public FakeArmorStand getArmorStand() {
        return this.armorStand;
    }
}

