/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.animation.keyframe;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.animation.handler.AnimationHandler;
import com.ticxo.modelengine.api.animation.handler.IPriorityHandler;
import com.ticxo.modelengine.api.animation.handler.IStateMachineHandler;
import com.ticxo.modelengine.api.animation.interpolator.KeyframeInterpolator;
import com.ticxo.modelengine.api.animation.interpolator.PrePostInterpolator;
import com.ticxo.modelengine.api.animation.interpolator.ScriptInterpolator;
import com.ticxo.modelengine.api.animation.keyframe.KeyframeType;
import com.ticxo.modelengine.api.animation.keyframe.type.ScriptKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.type.VectorKeyframe;
import com.ticxo.modelengine.api.animation.property.IAnimationProperty;
import com.ticxo.modelengine.api.animation.script.ScriptReader;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.utils.math.TMath;
import java.util.ArrayList;
import java.util.List;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class KeyframeTypes {
    public static final KeyframeType<VectorKeyframe, Vector3f> POSITION = KeyframeType.Builder.of("position", VectorKeyframe::new).interpolator(timeline -> new PrePostInterpolator(KeyframeTypes::standard)).registerBoneUpdater(IPriorityHandler.class, (handler, bone, data) -> {
        IAnimationProperty property = (IAnimationProperty)data[0];
        Vector3f output = bone.getCachedPosition();
        Vector3f val = property.getPositionFrame(bone.getBoneId());
        if (!property.isOverride()) {
            if (val == null) {
                val = new Vector3f();
            }
            switch (property.getPhase()) {
                case LERPIN: {
                    val = TMath.lerp(new Vector3f(), val, property.getLerpInRatio());
                    break;
                }
                case LERPOUT: {
                    val = TMath.lerp(val, new Vector3f(), property.getLerpOutRatio());
                }
            }
            output.add((Vector3fc)val);
        } else if (val != null) {
            switch (property.getPhase()) {
                case LERPIN: {
                    output.set((Vector3fc)TMath.lerp(output, val, property.getLerpInRatio()));
                    break;
                }
                case PLAY: {
                    output.set((Vector3fc)val);
                    break;
                }
                case LERPOUT: {
                    output.set((Vector3fc)TMath.lerp(val, output, property.getLerpOutRatio()));
                }
            }
        }
    }).registerBoneUpdater(IStateMachineHandler.class, (handler, bone, data) -> {
        IAnimationProperty currProperty = (IAnimationProperty)data[0];
        if (currProperty == null) {
            return;
        }
        Vector3f currVal = new Vector3f((Vector3fc)bone.getCachedPosition());
        Vector3f val = currProperty.getPositionFrame(bone.getBoneId());
        if (val != null) {
            if (!currProperty.isOverride()) {
                currVal.add((Vector3fc)val);
            } else {
                currVal.set((Vector3fc)val);
            }
        }
        switch (currProperty.getPhase()) {
            case PLAY: {
                bone.setCachedPosition(currVal);
                return;
            }
            case LERPOUT: {
                bone.setCachedPosition(TMath.lerp(currVal, bone.getCachedPosition(), currProperty.getLerpOutRatio()));
                return;
            }
        }
        IAnimationProperty lastProperty = (IAnimationProperty)data[1];
        if (lastProperty == null) {
            bone.setCachedPosition(TMath.lerp(bone.getCachedPosition(), currVal, currProperty.getLerpInRatio()));
            return;
        }
        Vector3f lastVal = new Vector3f((Vector3fc)bone.getCachedPosition());
        Vector3f val2 = lastProperty.getPositionFrame(bone.getBoneId());
        if (val2 != null) {
            if (!lastProperty.isOverride()) {
                lastVal.add((Vector3fc)val2);
            } else {
                lastVal.set((Vector3fc)val2);
            }
        }
        bone.setCachedPosition(TMath.lerp(lastVal, currVal, currProperty.getLerpInRatio()));
    }).build();
    public static final KeyframeType<VectorKeyframe, Vector3f> ROTATION = KeyframeType.Builder.of("rotation", VectorKeyframe::new).interpolator(timeline -> new PrePostInterpolator(KeyframeTypes::standard)).registerBoneUpdater(IPriorityHandler.class, (handler, bone, data) -> {
        IAnimationProperty property = (IAnimationProperty)data[0];
        Vector3f output = bone.getCachedLeftRotation();
        Vector3f val = property.getRotationFrame(bone.getBoneId());
        if (!property.isOverride()) {
            if (val == null) {
                val = new Vector3f();
            }
            switch (property.getPhase()) {
                case LERPIN: {
                    val = TMath.slerp(new Vector3f(), val, property.getLerpInRatio());
                    break;
                }
                case LERPOUT: {
                    val = TMath.slerp(val, new Vector3f(), property.getLerpOutRatio());
                }
            }
            output.add((Vector3fc)val);
        } else if (val != null) {
            switch (property.getPhase()) {
                case LERPIN: {
                    output.set((Vector3fc)TMath.slerp(output, val, property.getLerpInRatio()));
                    break;
                }
                case PLAY: {
                    output.set((Vector3fc)val);
                    break;
                }
                case LERPOUT: {
                    output.set((Vector3fc)TMath.slerp(val, output, property.getLerpOutRatio()));
                }
            }
        }
    }).registerBoneUpdater(IStateMachineHandler.class, (handler, bone, data) -> {
        IAnimationProperty currProperty = (IAnimationProperty)data[0];
        if (currProperty == null) {
            return;
        }
        Vector3f currVal = new Vector3f((Vector3fc)bone.getCachedLeftRotation());
        Vector3f val = currProperty.getRotationFrame(bone.getBoneId());
        if (val != null) {
            if (!currProperty.isOverride()) {
                currVal.add((Vector3fc)val);
            } else {
                currVal.set((Vector3fc)val);
            }
        }
        switch (currProperty.getPhase()) {
            case PLAY: {
                bone.setCachedLeftRotation(currVal);
                return;
            }
            case LERPOUT: {
                bone.setCachedLeftRotation(TMath.slerp(currVal, bone.getCachedLeftRotation(), currProperty.getLerpOutRatio()));
                return;
            }
        }
        IAnimationProperty lastProperty = (IAnimationProperty)data[1];
        if (lastProperty == null) {
            bone.setCachedLeftRotation(TMath.slerp(bone.getCachedLeftRotation(), currVal, currProperty.getLerpInRatio()));
            return;
        }
        Vector3f lastVal = new Vector3f((Vector3fc)bone.getCachedLeftRotation());
        Vector3f val2 = lastProperty.getRotationFrame(bone.getBoneId());
        if (val2 != null) {
            if (!lastProperty.isOverride()) {
                lastVal.add((Vector3fc)val2);
            } else {
                lastVal.set((Vector3fc)val2);
            }
        }
        bone.setCachedLeftRotation(TMath.slerp(lastVal, currVal, currProperty.getLerpInRatio()));
    }).build();
    public static final KeyframeType<VectorKeyframe, Vector3f> SCALE = KeyframeType.Builder.of("scale", VectorKeyframe::new).interpolator(timeline -> new PrePostInterpolator(KeyframeTypes::standard)).registerBoneUpdater(IPriorityHandler.class, (handler, bone, data) -> {
        IAnimationProperty property = (IAnimationProperty)data[0];
        Vector3f output = bone.getCachedScale();
        Vector3f val = property.getScaleFrame(bone.getBoneId());
        if (!property.isOverride()) {
            if (val == null) {
                val = new Vector3f(1.0f);
            }
            switch (property.getPhase()) {
                case LERPIN: {
                    val = TMath.lerp(new Vector3f(1.0f), val, property.getLerpInRatio());
                    break;
                }
                case LERPOUT: {
                    val = TMath.lerp(val, new Vector3f(1.0f), property.getLerpOutRatio());
                }
            }
            output.mul((Vector3fc)val);
        } else if (val != null) {
            switch (property.getPhase()) {
                case LERPIN: {
                    output.set((Vector3fc)TMath.lerp(output, val, property.getLerpInRatio()));
                    break;
                }
                case PLAY: {
                    output.set((Vector3fc)val);
                    break;
                }
                case LERPOUT: {
                    output.set((Vector3fc)TMath.lerp(val, output, property.getLerpOutRatio()));
                }
            }
        }
    }).registerBoneUpdater(IStateMachineHandler.class, (handler, bone, data) -> {
        IAnimationProperty currProperty = (IAnimationProperty)data[0];
        if (currProperty == null) {
            return;
        }
        Vector3f currVal = new Vector3f((Vector3fc)bone.getCachedScale());
        Vector3f val = currProperty.getScaleFrame(bone.getBoneId());
        if (val != null) {
            if (!currProperty.isOverride()) {
                currVal.mul((Vector3fc)val);
            } else {
                currVal.set((Vector3fc)val);
            }
        }
        switch (currProperty.getPhase()) {
            case PLAY: {
                bone.setCachedScale(currVal);
                return;
            }
            case LERPOUT: {
                bone.setCachedScale(TMath.lerp(currVal, bone.getCachedScale(), currProperty.getLerpOutRatio()));
                return;
            }
        }
        IAnimationProperty lastProperty = (IAnimationProperty)data[1];
        if (lastProperty == null) {
            bone.setCachedScale(TMath.lerp(bone.getCachedScale(), currVal, currProperty.getLerpInRatio()));
            return;
        }
        Vector3f lastVal = new Vector3f((Vector3fc)bone.getCachedScale());
        Vector3f val2 = lastProperty.getScaleFrame(bone.getBoneId());
        if (val2 != null) {
            if (!lastProperty.isOverride()) {
                lastVal.mul((Vector3fc)val2);
            } else {
                lastVal.set((Vector3fc)val2);
            }
        }
        bone.setCachedScale(TMath.lerp(lastVal, currVal, currProperty.getLerpInRatio()));
    }).build();
    public static final KeyframeType<ScriptKeyframe, List<ScriptKeyframe.Script>> SCRIPT = KeyframeType.Builder.of("script", ScriptKeyframe::new).interpolator(blueprintAnimation -> new ScriptInterpolator(ArrayList::new, List::addAll)).registerModelUpdater(IPriorityHandler.class, KeyframeTypes::standardScript).registerModelUpdater(IStateMachineHandler.class, KeyframeTypes::standardScript).global().build();

    private static Vector3f standard(KeyframeInterpolator.Context<VectorKeyframe, Vector3f> ctx, Vector3f prev, Vector3f next, float ratio) {
        VectorKeyframe keyframe = (VectorKeyframe)ctx.interpolator.get(Float.valueOf(ctx.nextKey));
        switch (keyframe.getInterpolation()) {
            default: {
                return prev.lerp((Vector3fc)next, ratio, new Vector3f());
            }
            case "catmullrom": {
                float nNextKey = ctx.interpolator.getHigherKey(ctx.nextKey);
                float pPrevKey = ctx.interpolator.getLowerKey(ctx.prevKey);
                VectorKeyframe nextControlVector = (VectorKeyframe)ctx.interpolator.get(Float.valueOf(nNextKey));
                VectorKeyframe lastControlVector = (VectorKeyframe)ctx.interpolator.get(Float.valueOf(pPrevKey));
                return TMath.smoothLerp(lastControlVector.getValue(0, ctx.property), prev, next, nextControlVector.getValue(0, ctx.property), ratio);
            }
            case "step": 
        }
        return prev;
    }

    private static void standardScript(AnimationHandler handler, ActiveModel model, Object ... data) {
        IAnimationProperty property = (IAnimationProperty)data[0];
        List<ScriptKeyframe.Script> scripts = property.getScriptFrame();
        if (scripts == null || scripts.isEmpty()) {
            return;
        }
        for (ScriptKeyframe.Script script : scripts) {
            ScriptReader reader = (ScriptReader)ModelEngineAPI.getAPI().getScriptReaderRegistry().get(script.reader());
            if (reader == null) continue;
            reader.read(property, script.script());
        }
    }
}

