/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.animation.property;

import com.ticxo.modelengine.api.animation.BlueprintAnimation;
import com.ticxo.modelengine.api.animation.Timeline;
import com.ticxo.modelengine.api.animation.handler.AnimationHandler;
import com.ticxo.modelengine.api.animation.keyframe.KeyframeType;
import com.ticxo.modelengine.api.animation.keyframe.type.ScriptKeyframe;
import com.ticxo.modelengine.api.animation.property.IAnimationProperty;
import com.ticxo.modelengine.api.generator.blueprint.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.utils.data.io.SavedData;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class SimpleProperty
implements IAnimationProperty {
    private final ActiveModel model;
    private final BlueprintAnimation blueprintAnimation;
    private final double lerpIn;
    private final double lerpOut;
    private double lerpInTime = 0.0;
    private double lerpOutTime = 0.0;
    private double lastTime = -1.0;
    private double time = -1.0;
    private double speed;
    @NotNull
    private IAnimationProperty.Phase phase = IAnimationProperty.Phase.LERPIN;
    private BlueprintAnimation.LoopMode forceLoopMode = null;
    private boolean forceOverride = false;
    private boolean ended;

    public SimpleProperty(ActiveModel model, BlueprintAnimation blueprintAnimation) {
        this(model, blueprintAnimation, 0.0, 0.0, 1.0);
    }

    public SimpleProperty(ActiveModel model, BlueprintAnimation blueprintAnimation, double lerpIn, double lerpOut, double speed) {
        this.model = model;
        this.blueprintAnimation = blueprintAnimation;
        this.lerpIn = lerpIn;
        this.lerpOut = lerpOut;
        this.speed = speed;
    }

    @Override
    public boolean update() {
        this.lastTime = this.time;
        return switch (this.phase) {
            default -> throw new IncompatibleClassChangeError();
            case IAnimationProperty.Phase.LERPIN -> this.updateLerpIn();
            case IAnimationProperty.Phase.PLAY -> this.updateTime();
            case IAnimationProperty.Phase.LERPOUT -> this.updateLerpOut();
        };
    }

    private boolean updateLerpIn() {
        if (this.lerpInTime >= this.lerpIn - 1.0E-5) {
            this.time = 0.0;
            return this.updateTime();
        }
        this.lerpInTime += this.speed * 0.05;
        return true;
    }

    private boolean updateTime() {
        if (this.phase == IAnimationProperty.Phase.LERPIN) {
            this.phase = IAnimationProperty.Phase.PLAY;
            return true;
        }
        BlueprintAnimation.LoopMode mode = this.getLoopMode();
        switch (mode) {
            case ONCE: {
                if (this.time < this.blueprintAnimation.getLength()) {
                    this.time = Math.min(this.time + this.speed * 0.05, this.blueprintAnimation.getLength());
                    return true;
                }
                return this.updateLerpOut();
            }
            case HOLD: {
                this.time = Math.min(this.time + this.speed * 0.05, this.blueprintAnimation.getLength());
                return true;
            }
            case LOOP: {
                this.time = (this.time + this.speed * 0.05) % (this.blueprintAnimation.getLength() + 0.05);
                return true;
            }
        }
        return false;
    }

    private boolean updateLerpOut() {
        if (this.phase == IAnimationProperty.Phase.PLAY && this.lerpOut > 1.0E-5) {
            this.phase = IAnimationProperty.Phase.LERPOUT;
            return true;
        }
        if (this.lerpOutTime >= this.lerpOut - 1.0E-5) {
            this.ended = true;
            return false;
        }
        this.lerpOutTime += this.speed * 0.05;
        return true;
    }

    @Override
    public void stop() {
        this.phase = IAnimationProperty.Phase.LERPOUT;
    }

    @Override
    public String getName() {
        return this.blueprintAnimation.getName();
    }

    @Override
    public boolean containsKeyframe(KeyframeType<?, ?> type, String bone) {
        Timeline timeline = this.blueprintAnimation.getTimelines().get(bone);
        if (timeline == null) {
            return false;
        }
        return timeline.hasInterpolator(type) && !timeline.getInterpolator(type).isEmpty();
    }

    @Override
    public Vector3f getPositionFrame(String bone) {
        return this.blueprintAnimation.getPosition(bone, this);
    }

    @Override
    public Vector3f getRotationFrame(String bone) {
        return this.blueprintAnimation.getRotation(bone, this);
    }

    @Override
    public Vector3f getScaleFrame(String bone) {
        return this.blueprintAnimation.getScale(bone, this);
    }

    @Override
    public List<ScriptKeyframe.Script> getScriptFrame() {
        return this.blueprintAnimation.getScript(this);
    }

    @Override
    public double getLerpInRatio() {
        return this.lerpInTime / this.lerpIn;
    }

    @Override
    public double getLerpOutRatio() {
        return this.lerpOutTime / this.lerpOut;
    }

    @Override
    public boolean isFinished() {
        return this.phase == IAnimationProperty.Phase.LERPOUT || this.time >= this.blueprintAnimation.getLength();
    }

    @Override
    public BlueprintAnimation.LoopMode getLoopMode() {
        return this.forceLoopMode == null ? this.blueprintAnimation.getLoopMode() : this.forceLoopMode;
    }

    @Override
    public boolean isOverride() {
        return this.blueprintAnimation.isOverride() || this.forceOverride;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lerpIn, this.lerpOut, this.time, this.speed, this.phase, this.forceLoopMode, this.forceOverride});
    }

    @Override
    public void save(SavedData data) {
        data.putString("id", "simple");
        data.putString("name", this.getName());
        data.putDouble("lerp_in", this.lerpIn);
        data.putDouble("lerp_out", this.lerpOut);
        data.putDouble("lerp_in_time", this.lerpInTime);
        data.putDouble("lerp_out_time", this.lerpOutTime);
        data.putDouble("last_time", this.lastTime);
        data.putDouble("time", this.time);
        data.putDouble("speed", this.speed);
        data.putString("phase", this.phase.name());
        if (this.forceLoopMode != null) {
            data.putString("force_loop_mode", this.forceLoopMode.name());
        }
        data.putBoolean("force_override", this.forceOverride);
    }

    @Override
    public void load(SavedData data) {
        this.lerpInTime = data.getDouble("lerp_in_time");
        this.lerpOutTime = data.getDouble("lerp_out_time");
        this.lastTime = data.getDouble("last_time");
        this.time = data.getDouble("time");
        this.phase = IAnimationProperty.Phase.valueOf(data.getString("phase"));
        data.loadIfExist("force_loop_mode", SavedData::getString, val -> {
            this.forceLoopMode = BlueprintAnimation.LoopMode.getOrNull(val);
        });
        this.forceOverride = data.getBoolean("force_override");
    }

    public static SimpleProperty create(AnimationHandler handler, SavedData data) {
        ActiveModel model = handler.getActiveModel();
        ModelBlueprint blueprint = model.getBlueprint();
        BlueprintAnimation animation = blueprint.getAnimations().get(data.getString("name"));
        SimpleProperty property = new SimpleProperty(model, animation, data.getDouble("lerp_in", 0.0), data.getDouble("lerp_out", 0.0), data.getDouble("speed", 1.0));
        property.load(data);
        return property;
    }

    public String toString() {
        return "SimpleProperty(model=" + this.getModel() + ", blueprintAnimation=" + this.getBlueprintAnimation() + ", lerpIn=" + this.getLerpIn() + ", lerpOut=" + this.getLerpOut() + ", lerpInTime=" + this.getLerpInTime() + ", lerpOutTime=" + this.getLerpOutTime() + ", lastTime=" + this.getLastTime() + ", time=" + this.getTime() + ", speed=" + this.getSpeed() + ", phase=" + this.getPhase() + ", forceLoopMode=" + this.getForceLoopMode() + ", forceOverride=" + this.isForceOverride() + ", ended=" + this.isEnded() + ")";
    }

    @Override
    public ActiveModel getModel() {
        return this.model;
    }

    @Override
    public BlueprintAnimation getBlueprintAnimation() {
        return this.blueprintAnimation;
    }

    @Override
    public double getLerpIn() {
        return this.lerpIn;
    }

    @Override
    public double getLerpOut() {
        return this.lerpOut;
    }

    @Override
    public double getLerpInTime() {
        return this.lerpInTime;
    }

    @Override
    public double getLerpOutTime() {
        return this.lerpOutTime;
    }

    @Override
    public double getLastTime() {
        return this.lastTime;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    @Override
    public double getSpeed() {
        return this.speed;
    }

    @Override
    @NotNull
    public IAnimationProperty.Phase getPhase() {
        return this.phase;
    }

    @Override
    public BlueprintAnimation.LoopMode getForceLoopMode() {
        return this.forceLoopMode;
    }

    @Override
    public boolean isForceOverride() {
        return this.forceOverride;
    }

    @Override
    public boolean isEnded() {
        return this.ended;
    }

    @Override
    public void setLerpInTime(double lerpInTime) {
        this.lerpInTime = lerpInTime;
    }

    @Override
    public void setLerpOutTime(double lerpOutTime) {
        this.lerpOutTime = lerpOutTime;
    }

    @Override
    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public void setPhase(@NotNull IAnimationProperty.Phase phase) {
        if (phase == null) {
            throw new NullPointerException("phase is marked non-null but is null");
        }
        this.phase = phase;
    }

    @Override
    public void setForceLoopMode(BlueprintAnimation.LoopMode forceLoopMode) {
        this.forceLoopMode = forceLoopMode;
    }

    @Override
    public void setForceOverride(boolean forceOverride) {
        this.forceOverride = forceOverride;
    }
}

