/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.entity.data;

import com.ticxo.modelengine.api.entity.CullType;
import com.ticxo.modelengine.api.entity.Hitbox;
import com.ticxo.modelengine.api.entity.data.IEntityData;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.api.utils.math.TMath;

public abstract class AbstractEntityData
implements IEntityData {
    private static int CULL_INTERVAL;
    private static boolean CULL_VERTICAL;
    private static double CULL_VERTICAL_DISTANCE;
    private static CullType CULL_VERTICAL_TYPE;
    private static boolean CULL_BEHIND;
    private static double VIEW_ANGLE;
    private static double UPDATE_BEHIND_RADIUS_SQR;
    private static CullType CULL_BEHIND_TYPE;
    private static boolean CULL_BLOCKED;
    private static double FORCE_UNBLOCKED_RADIUS_SQR;
    private static CullType CULL_BLOCKED_TYPE;
    private Hitbox cullHitbox;
    private Integer cullInterval;
    private Boolean verticalCull;
    private Double verticalCullDistance;
    private CullType verticalCullType;
    private Boolean backCull;
    private Double backCullAngle;
    private Double backCullIgnoreRadius;
    private CullType backCullType;
    private Boolean blockedCull;
    private Double blockedCullIgnoreRadius;
    private CullType blockedCullType;

    public static void updateConfig() {
        CULL_INTERVAL = Math.max(ConfigProperty.CULL_INTERVAL.getInt(), 1);
        CULL_VERTICAL = ConfigProperty.VERTICAL_CULL_ENABLE.getBoolean();
        CULL_VERTICAL_DISTANCE = ConfigProperty.VERTICAL_CULL_DISTANCE.getDouble();
        CULL_VERTICAL_TYPE = ConfigProperty.VERTICAL_CULL_TYPE.getCullType();
        CULL_BEHIND = ConfigProperty.BACKWARDS_CULL_ENABLED.getBoolean();
        VIEW_ANGLE = Math.cos(TMath.clamp(ConfigProperty.BACKWARDS_CULL_ANGLE.getDouble(), 0.0, 360.0) * 0.5 * 0.01745329238474369);
        UPDATE_BEHIND_RADIUS_SQR = ConfigProperty.BACKWARDS_CULL_IGNORE_RADIUS.getDouble();
        UPDATE_BEHIND_RADIUS_SQR *= UPDATE_BEHIND_RADIUS_SQR;
        CULL_BEHIND_TYPE = ConfigProperty.BACKWARDS_CULL_TYPE.getCullType();
        CULL_BLOCKED = ConfigProperty.BLOCK_CULL_ENABLE.getBoolean();
        FORCE_UNBLOCKED_RADIUS_SQR = ConfigProperty.BLOCK_CULL_IGNORE_RADIUS.getDouble();
        FORCE_UNBLOCKED_RADIUS_SQR *= FORCE_UNBLOCKED_RADIUS_SQR;
        CULL_BLOCKED_TYPE = ConfigProperty.BLOCK_CULL_TYPE.getCullType();
    }

    @Override
    public int cullInterval() {
        return this.cullInterval == null ? CULL_INTERVAL : this.cullInterval;
    }

    @Override
    public boolean verticalCull() {
        return this.verticalCull == null ? CULL_VERTICAL : this.verticalCull;
    }

    @Override
    public double verticalCullDistance() {
        return this.verticalCullDistance == null ? CULL_VERTICAL_DISTANCE : this.verticalCullDistance;
    }

    @Override
    public CullType verticalCullType() {
        return this.verticalCullType == null ? CULL_VERTICAL_TYPE : this.verticalCullType;
    }

    @Override
    public boolean backCull() {
        return this.backCull == null ? CULL_BEHIND : this.backCull;
    }

    @Override
    public double backCullAngle() {
        return this.backCullAngle == null ? VIEW_ANGLE : this.backCullAngle;
    }

    @Override
    public double backCullIgnoreRadius() {
        return this.backCullIgnoreRadius == null ? UPDATE_BEHIND_RADIUS_SQR : this.backCullIgnoreRadius * this.backCullIgnoreRadius;
    }

    @Override
    public CullType backCullType() {
        return this.backCullType == null ? CULL_BEHIND_TYPE : this.backCullType;
    }

    @Override
    public boolean blockedCull() {
        return this.blockedCull == null ? CULL_BLOCKED : this.blockedCull;
    }

    @Override
    public double blockedCullIgnoreRadius() {
        return this.blockedCullIgnoreRadius == null ? FORCE_UNBLOCKED_RADIUS_SQR : this.blockedCullIgnoreRadius * this.blockedCullIgnoreRadius;
    }

    @Override
    public CullType blockedCullType() {
        return this.blockedCullType == null ? CULL_BLOCKED_TYPE : this.blockedCullType;
    }

    @Override
    public Hitbox getCullHitbox() {
        return this.cullHitbox;
    }

    @Override
    public void setCullHitbox(Hitbox cullHitbox) {
        this.cullHitbox = cullHitbox;
    }

    @Override
    public Integer getCullInterval() {
        return this.cullInterval;
    }

    @Override
    public void setCullInterval(Integer cullInterval) {
        this.cullInterval = cullInterval;
    }

    @Override
    public Boolean getVerticalCull() {
        return this.verticalCull;
    }

    @Override
    public void setVerticalCull(Boolean verticalCull) {
        this.verticalCull = verticalCull;
    }

    @Override
    public Double getVerticalCullDistance() {
        return this.verticalCullDistance;
    }

    @Override
    public void setVerticalCullDistance(Double verticalCullDistance) {
        this.verticalCullDistance = verticalCullDistance;
    }

    @Override
    public CullType getVerticalCullType() {
        return this.verticalCullType;
    }

    @Override
    public void setVerticalCullType(CullType verticalCullType) {
        this.verticalCullType = verticalCullType;
    }

    @Override
    public Boolean getBackCull() {
        return this.backCull;
    }

    @Override
    public void setBackCull(Boolean backCull) {
        this.backCull = backCull;
    }

    @Override
    public Double getBackCullAngle() {
        return this.backCullAngle;
    }

    @Override
    public void setBackCullAngle(Double backCullAngle) {
        this.backCullAngle = backCullAngle;
    }

    @Override
    public Double getBackCullIgnoreRadius() {
        return this.backCullIgnoreRadius;
    }

    @Override
    public void setBackCullIgnoreRadius(Double backCullIgnoreRadius) {
        this.backCullIgnoreRadius = backCullIgnoreRadius;
    }

    @Override
    public CullType getBackCullType() {
        return this.backCullType;
    }

    @Override
    public void setBackCullType(CullType backCullType) {
        this.backCullType = backCullType;
    }

    @Override
    public Boolean getBlockedCull() {
        return this.blockedCull;
    }

    @Override
    public void setBlockedCull(Boolean blockedCull) {
        this.blockedCull = blockedCull;
    }

    @Override
    public Double getBlockedCullIgnoreRadius() {
        return this.blockedCullIgnoreRadius;
    }

    @Override
    public void setBlockedCullIgnoreRadius(Double blockedCullIgnoreRadius) {
        this.blockedCullIgnoreRadius = blockedCullIgnoreRadius;
    }

    @Override
    public CullType getBlockedCullType() {
        return this.blockedCullType;
    }

    @Override
    public void setBlockedCullType(CullType blockedCullType) {
        this.blockedCullType = blockedCullType;
    }
}

