/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.entity.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.CullType;
import com.ticxo.modelengine.api.entity.Dummy;
import com.ticxo.modelengine.api.entity.data.AbstractEntityData;
import com.ticxo.modelengine.api.nms.impl.DummyTrackedEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DummyEntityData<T>
extends AbstractEntityData {
    protected final Dummy<T> dummy;
    protected final DummyTrackedEntity tracked;
    protected final Set<Player> syncTracking = new HashSet<Player>();
    protected final Map<Player, CullType> asyncTracking = new HashMap<Player, CullType>();
    protected final Queue<Player> startTrackingQueue = new ConcurrentLinkedQueue<Player>();
    protected final Set<Player> startTracking = new HashSet<Player>();
    protected final Queue<Player> stopTrackingQueue = new ConcurrentLinkedQueue<Player>();
    protected final Set<Player> stopTracking = new HashSet<Player>();
    protected Location location;

    public DummyEntityData(Dummy<T> dummy) {
        this.dummy = dummy;
        this.tracked = new DummyTrackedEntity();
        this.syncUpdate();
        this.asyncUpdate();
        ModelEngineAPI.getAPI().getDataTracker().putEntityData(dummy.getUUID(), this);
    }

    @Override
    public void asyncUpdate() {
        Player player;
        while (!this.startTrackingQueue.isEmpty()) {
            player = this.startTrackingQueue.poll();
            this.startTracking.add(player);
            this.asyncTracking.put(player, CullType.NO_CULL);
        }
        while (!this.stopTrackingQueue.isEmpty()) {
            player = this.stopTrackingQueue.poll();
            this.stopTracking.add(player);
            if (this.asyncTracking.get(player) == CullType.CULLED) continue;
            this.asyncTracking.remove(player);
        }
    }

    @Override
    public void syncUpdate() {
        if (this.dummy.isDetectingPlayers()) {
            this.tracked.detectPlayers(this.location);
        }
        Set<Player> updatedTracking = this.tracked.getTrackedPlayer(player -> this.asyncTracking.get(player) != CullType.CULLED);
        HashSet<Player> all = new HashSet<Player>(this.syncTracking);
        all.addAll(updatedTracking);
        for (Player player2 : all) {
            if (!this.syncTracking.contains(player2)) {
                this.startTrackingQueue.add(player2);
                continue;
            }
            if (updatedTracking.contains(player2)) continue;
            this.stopTrackingQueue.add(player2);
        }
        this.syncTracking.clear();
        this.syncTracking.addAll(updatedTracking);
    }

    @Override
    public void cleanup() {
        this.startTracking.clear();
        this.stopTracking.clear();
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean isDataValid() {
        return this.dummy.isAlive();
    }

    @Override
    public List<Entity> getPassengers() {
        return List.of();
    }

    @Override
    public Set<Player> getStartTracking() {
        return ImmutableSet.copyOf(this.startTracking);
    }

    @Override
    public Map<Player, CullType> getTracking() {
        return ImmutableMap.copyOf(this.asyncTracking);
    }

    @Override
    public Set<Player> getStopTracking() {
        return ImmutableSet.copyOf(this.stopTracking);
    }

    public int getRenderRadius() {
        return this.tracked.getBaseRange();
    }

    public void setRenderRadius(int radius) {
        this.tracked.setBaseRange(radius);
    }

    public DummyTrackedEntity getTracked() {
        return this.tracked;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }
}

