/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehavior;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehaviorType;
import com.ticxo.modelengine.api.model.bone.behavior.GlobalBehaviorData;
import com.ticxo.modelengine.api.model.bone.manager.MountData;
import com.ticxo.modelengine.api.utils.data.io.DataIO;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ModeledEntity
extends DataIO {
    public BaseEntity<?> getBase();

    public int getTick();

    public boolean tick();

    public void destroy();

    public boolean isInitialized();

    public boolean isDestroyed();

    public void markRemoved();

    public void queuePostInitTask(Runnable var1);

    public boolean isBaseEntityVisible();

    public void setBaseEntityVisible(boolean var1);

    public void markHurt();

    public int getHurtTick();

    public boolean shouldBeSaved();

    public void setSaved(boolean var1);

    public boolean isModelRotationLocked();

    public void setModelRotationLocked(boolean var1);

    public float getYHeadRot();

    public float getXHeadRot();

    public float getYBodyRot();

    public Optional<ActiveModel> addModel(@NotNull ActiveModel var1, boolean var2);

    public Optional<ActiveModel> removeModel(String var1);

    public Optional<ActiveModel> getModel(@Nullable String var1);

    public Map<String, ActiveModel> getModels();

    public <T extends BoneBehavior> GlobalBehaviorData getOrCreateGlobalBehaviorData(BoneBehaviorType<T> var1, Supplier<GlobalBehaviorData> var2);

    public <T extends BoneBehavior> GlobalBehaviorData getGlobalBehaviorData(BoneBehaviorType<T> var1);

    public <T extends BoneBehavior> GlobalBehaviorData removeGlobalBehaviorData(BoneBehaviorType<T> var1);

    public Map<BoneBehaviorType<?>, GlobalBehaviorData> getAllGlobalBehaviorData(BoneBehaviorType<?> var1);

    public <T extends GlobalBehaviorData & MountData> T getMountData();

    default public void registerSelf() {
        ModelEngineAPI.getAPI().getModelUpdater().registerModeledEntity(this.getBase(), this).ifPresent(ModeledEntity::destroy);
    }
}

