/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.generator;

import com.ticxo.modelengine.api.generator.blueprint.BlueprintBone;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class ModelIdCache {
    protected final Map<String, Integer> cachedId = new HashMap<String, Integer>();
    protected final Queue<Integer> unused = new LinkedList<Integer>();
    private final transient Map<String, BlueprintBone> requested = new LinkedHashMap<String, BlueprintBone>();
    private final transient Set<String> pendingRemove = new HashSet<String>();
    protected int nextId = 1;

    public void endSession() {
        String modelId;
        int maxId = 0;
        for (Map.Entry<String, Integer> entry : this.cachedId.entrySet()) {
            modelId = entry.getKey();
            Integer dataId = entry.getValue();
            if (this.requested.containsKey(modelId)) {
                this.requested.remove(modelId).setDataId(dataId);
                maxId = Math.max(dataId, maxId);
                continue;
            }
            this.pendingRemove.add(modelId);
            this.unused.add(this.cachedId.get(modelId));
        }
        this.pendingRemove.forEach(this.cachedId::remove);
        this.pendingRemove.clear();
        for (Map.Entry<String, Object> entry : this.requested.entrySet()) {
            modelId = entry.getKey();
            BlueprintBone bone = (BlueprintBone)entry.getValue();
            if (!this.unused.isEmpty()) {
                bone.setDataId(this.unused.poll());
            } else {
                bone.setDataId(this.nextId++);
            }
            maxId = Math.max(bone.getDataId(), maxId);
            this.cachedId.put(modelId, bone.getDataId());
        }
        Iterator<Map.Entry<String, Object>> iterator = this.unused.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)((Object)iterator.next());
            maxId = Math.max(maxId, n);
        }
        this.nextId = maxId + 1;
        this.requested.clear();
    }

    public void requestId(String modelId, BlueprintBone bone) {
        this.requested.put(modelId + ":" + bone.getName(), bone);
    }
}

