/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.generator.parser.blockbench.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.ticxo.modelengine.api.animation.BlueprintAnimation;
import com.ticxo.modelengine.api.model.bone.BoneBehaviorTypes;
import com.ticxo.modelengine.api.model.bone.type.PlayerLimb;
import com.ticxo.modelengine.api.utils.TFile;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.api.utils.data.GSONUtils;
import com.ticxo.modelengine.core.generator.parser.blockbench.json.BlockbenchModel;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.bukkit.entity.ItemDisplay;
import org.jetbrains.annotations.Nullable;

public class BlockbenchDeserializer<T extends BlockbenchModel>
implements JsonDeserializer<T> {
    private final Map<UUID, BlockbenchModel.Bone> boneCache = new HashMap<UUID, BlockbenchModel.Bone>();
    private final Map<UUID, BlockbenchModel.Texture> textureCache = new HashMap<UUID, BlockbenchModel.Texture>();
    private final Supplier<T> supplier;
    private final boolean readOptions;

    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        BlockbenchModel model = (BlockbenchModel)this.supplier.get();
        JsonObject root = json.getAsJsonObject();
        String namespace = ConfigProperty.NAMESPACE.getString().toLowerCase(Locale.ENGLISH);
        GSONUtils.ifPresent((JsonElement)root, "resolution", element -> {
            GSONUtils.ifPresent(element, "width", width -> {
                model.resolution[0] = width.getAsInt();
            });
            GSONUtils.ifPresent(element, "height", height -> {
                model.resolution[1] = height.getAsInt();
            });
        });
        GSONUtils.ifArray((JsonElement)root, "elements", element -> {
            BlockbenchModel.Element bbElement;
            String type;
            switch (type = GSONUtils.get(element, "type", JsonElement::getAsString, "cube")) {
                case "cube": {
                    BlockbenchModel.Cube cube = new BlockbenchModel.Cube();
                    GSONUtils.ifPresent(element, "from", from -> {
                        JsonArray array = from.getAsJsonArray();
                        cube.from[0] = array.get(0).getAsFloat();
                        cube.from[1] = array.get(1).getAsFloat();
                        cube.from[2] = array.get(2).getAsFloat();
                    });
                    GSONUtils.ifPresent(element, "to", to -> {
                        JsonArray array = to.getAsJsonArray();
                        cube.to[0] = array.get(0).getAsFloat();
                        cube.to[1] = array.get(1).getAsFloat();
                        cube.to[2] = array.get(2).getAsFloat();
                    });
                    GSONUtils.ifPresent(element, "rotation", rotation -> {
                        JsonArray array = rotation.getAsJsonArray();
                        cube.rotation[0] = array.get(0).getAsFloat();
                        cube.rotation[1] = array.get(1).getAsFloat();
                        cube.rotation[2] = array.get(2).getAsFloat();
                    });
                    cube.inflate = GSONUtils.get(element, "inflate", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
                    GSONUtils.ifPresent(element, "origin", origin -> {
                        JsonArray array = origin.getAsJsonArray();
                        cube.origin[0] = array.get(0).getAsFloat();
                        cube.origin[1] = array.get(1).getAsFloat();
                        cube.origin[2] = array.get(2).getAsFloat();
                    });
                    GSONUtils.ifPresent(element, "faces", e -> {
                        JsonObject faces = e.getAsJsonObject();
                        for (String dir : faces.keySet()) {
                            BlockbenchModel.Cube.Face face = new BlockbenchModel.Cube.Face();
                            JsonObject faceObject = faces.getAsJsonObject(dir);
                            GSONUtils.ifPresent((JsonElement)faceObject, "uv", uv -> {
                                JsonArray array = uv.getAsJsonArray();
                                face.uv[0] = array.get(0).getAsFloat();
                                face.uv[1] = array.get(1).getAsFloat();
                                face.uv[2] = array.get(2).getAsFloat();
                                face.uv[3] = array.get(3).getAsFloat();
                            });
                            face.rotation = GSONUtils.get((JsonElement)faceObject, "rotation", JsonElement::getAsInt, 0);
                            face.texture = GSONUtils.get((JsonElement)faceObject, "texture", JsonElement::getAsInt, -1);
                            cube.faces.put(dir, face);
                        }
                    });
                    bbElement = cube;
                    break;
                }
                case "null_object": {
                    BlockbenchModel.NullObject nullObject = new BlockbenchModel.NullObject();
                    GSONUtils.ifPresent(element, "position", position -> {
                        JsonArray array = position.getAsJsonArray();
                        nullObject.position[0] = array.get(0).getAsFloat();
                        nullObject.position[1] = array.get(1).getAsFloat();
                        nullObject.position[2] = array.get(2).getAsFloat();
                    });
                    bbElement = nullObject;
                    break;
                }
                default: {
                    return;
                }
            }
            bbElement.name = GSONUtils.get(element, "name", JsonElement::getAsString, "");
            bbElement.uuid = GSONUtils.get(element, "uuid", ele -> UUID.fromString(ele.getAsString()));
            bbElement.export = GSONUtils.get(element, "export", JsonElement::getAsBoolean, true);
            model.elements.put(bbElement.uuid, bbElement);
        });
        GSONUtils.ifPresent((JsonElement)root, "outliner", outliner -> this.readBones((JsonElement)outliner, model.outliner, null));
        GSONUtils.ifArray((JsonElement)root, "textures", (index, texture) -> {
            BlockbenchModel.Texture bbTexture = new BlockbenchModel.Texture();
            bbTexture.name = TFile.removeExtension(GSONUtils.get(texture, "name", JsonElement::getAsString, "").toLowerCase(Locale.ENGLISH));
            bbTexture.namespace = GSONUtils.get(texture, "namespace", element -> {
                String s = element.getAsString();
                return s == null || s.isEmpty() ? null : s;
            }, namespace).toLowerCase(Locale.ENGLISH);
            bbTexture.folder = bbTexture.namespace.equals(namespace) ? "entity" : GSONUtils.get(texture, "folder", JsonElement::getAsString, "entity").toLowerCase(Locale.ENGLISH);
            bbTexture.id = GSONUtils.get(texture, "id", JsonElement::getAsString, "");
            bbTexture.frame_time = GSONUtils.get(texture, "frame_time", JsonElement::getAsInt, 1);
            bbTexture.frame_order = GSONUtils.get(texture, "frame_order", element -> {
                String orderString = element.getAsString();
                if (orderString == null || orderString.isBlank()) {
                    return new int[0];
                }
                String[] order = orderString.split(" ");
                int[] intOrder = new int[order.length];
                for (int i = 0; i < order.length; ++i) {
                    intOrder[i] = Integer.parseInt(order[i]);
                }
                return intOrder;
            });
            bbTexture.frame_interpolate = GSONUtils.get(texture, "frame_interpolate", JsonElement::getAsBoolean, false);
            bbTexture.uuid = GSONUtils.get(texture, "uuid", jsonElement -> UUID.fromString(jsonElement.getAsString()));
            bbTexture.source = GSONUtils.get(texture, "source", JsonElement::getAsString);
            bbTexture.uvWidth = GSONUtils.get(texture, "uv_width", JsonElement::getAsInt, model.resolution[0]);
            bbTexture.uvHeight = GSONUtils.get(texture, "uv_height", JsonElement::getAsInt, model.resolution[1]);
            model.textures.put((Integer)index, bbTexture);
            this.textureCache.put(bbTexture.uuid, bbTexture);
        });
        GSONUtils.ifPresent((JsonElement)root, "mcmetas", element -> {
            JsonObject elementData = element.getAsJsonObject();
            for (Map.Entry entry : elementData.entrySet()) {
                UUID uuid = UUID.fromString((String)entry.getKey());
                BlockbenchModel.Texture texture = this.textureCache.get(uuid);
                if (texture == null) continue;
                texture.raw_mcmeta = ((JsonElement)entry.getValue()).toString();
            }
        });
        GSONUtils.ifArray((JsonElement)root, "animations", animation -> {
            BlockbenchModel.Animation bbAnimation = new BlockbenchModel.Animation();
            bbAnimation.name = GSONUtils.get(animation, "name", JsonElement::getAsString);
            bbAnimation.loop = BlueprintAnimation.LoopMode.get(GSONUtils.get(animation, "loop", JsonElement::getAsString, "once"));
            bbAnimation.override = GSONUtils.get(animation, "override", JsonElement::getAsBoolean, false);
            bbAnimation.length = GSONUtils.get(animation, "length", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
            bbAnimation.effects = new BlockbenchModel.Animation.Animator();
            bbAnimation.effects.name = "effects";
            GSONUtils.ifPresent(animation, "animators", animators -> {
                JsonObject jsonAnimators = animators.getAsJsonObject();
                for (String key : jsonAnimators.keySet()) {
                    BlockbenchModel.Animation.Animator bbAnimator;
                    JsonObject jsonAnimator = jsonAnimators.getAsJsonObject(key);
                    if (key.equals("effects")) {
                        bbAnimator = bbAnimation.effects;
                    } else {
                        UUID uuid = UUID.fromString(key);
                        bbAnimator = bbAnimation.animators.computeIfAbsent(uuid, id -> {
                            BlockbenchModel.Animation.Animator animator = new BlockbenchModel.Animation.Animator();
                            BlockbenchModel.Bone bone = this.boneCache.get(id);
                            animator.name = bone == null ? "" : bone.name;
                            animator.uuid = id;
                            animator.globalRotation = GSONUtils.get((JsonElement)jsonAnimator, "rotation_global", JsonElement::getAsBoolean, false);
                            return animator;
                        });
                    }
                    GSONUtils.ifArray((JsonElement)jsonAnimator, "keyframes", keyframe -> {
                        JsonObject jsonKeyframe = keyframe.getAsJsonObject();
                        BlockbenchModel.Animation.Animator.Keyframe bbKeyframe = new BlockbenchModel.Animation.Animator.Keyframe();
                        bbKeyframe.channel = GSONUtils.get((JsonElement)jsonKeyframe, "channel", JsonElement::getAsString, "unknown");
                        bbKeyframe.time = GSONUtils.get((JsonElement)jsonKeyframe, "time", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
                        bbKeyframe.interpolation = GSONUtils.get((JsonElement)jsonKeyframe, "interpolation", JsonElement::getAsString, "linear");
                        GSONUtils.ifPresent((JsonElement)jsonKeyframe, "bezier_left_time", leftTime -> {
                            JsonArray array = leftTime.getAsJsonArray();
                            bbKeyframe.bezierLeftTime[0] = array.get(0).getAsFloat();
                            bbKeyframe.bezierLeftTime[1] = array.get(1).getAsFloat();
                            bbKeyframe.bezierLeftTime[2] = array.get(2).getAsFloat();
                        });
                        GSONUtils.ifPresent((JsonElement)jsonKeyframe, "bezier_left_value", leftValue -> {
                            JsonArray array = leftValue.getAsJsonArray();
                            bbKeyframe.bezierLeftValue[0] = array.get(0).getAsFloat();
                            bbKeyframe.bezierLeftValue[1] = array.get(1).getAsFloat();
                            bbKeyframe.bezierLeftValue[2] = array.get(2).getAsFloat();
                        });
                        GSONUtils.ifPresent((JsonElement)jsonKeyframe, "bezier_right_time", rightTime -> {
                            JsonArray array = rightTime.getAsJsonArray();
                            bbKeyframe.bezierRightTime[0] = array.get(0).getAsFloat();
                            bbKeyframe.bezierRightTime[1] = array.get(1).getAsFloat();
                            bbKeyframe.bezierRightTime[2] = array.get(2).getAsFloat();
                        });
                        GSONUtils.ifPresent((JsonElement)jsonKeyframe, "bezier_right_value", rightValue -> {
                            JsonArray array = rightValue.getAsJsonArray();
                            bbKeyframe.bezierRightValue[0] = array.get(0).getAsFloat();
                            bbKeyframe.bezierRightValue[1] = array.get(1).getAsFloat();
                            bbKeyframe.bezierRightValue[2] = array.get(2).getAsFloat();
                        });
                        GSONUtils.ifArray((JsonElement)jsonKeyframe, "data_points", data -> {
                            JsonObject jsonData = data.getAsJsonObject();
                            HashMap<String, String> dataMap = new HashMap<String, String>();
                            for (String dataKey : jsonData.keySet()) {
                                dataMap.put(dataKey, jsonData.get(dataKey).getAsString());
                            }
                            bbKeyframe.data.add(dataMap);
                        });
                        bbAnimator.channels.computeIfAbsent(bbKeyframe.channel, s -> new HashMap()).put(Float.valueOf(bbKeyframe.time), bbKeyframe);
                    });
                }
            });
            model.animations.put(bbAnimation.name, bbAnimation);
        });
        GSONUtils.ifPresent((JsonElement)root, "animation_variable_placeholders", element -> {
            model.animationPlaceholder = element.getAsString();
        });
        this.boneCache.clear();
        this.textureCache.clear();
        return (T)model;
    }

    private void readBones(JsonElement element, Map<String, BlockbenchModel.Bone> boneMap, @Nullable Set<UUID> elementSet) {
        if (!(element instanceof JsonArray)) {
            return;
        }
        JsonArray array = (JsonArray)element;
        for (JsonElement entry : array) {
            if (!entry.isJsonObject()) {
                if (elementSet == null) continue;
                elementSet.add(UUID.fromString(entry.getAsString()));
                continue;
            }
            JsonObject jsonBone = entry.getAsJsonObject();
            BlockbenchModel.Bone bbBone = new BlockbenchModel.Bone();
            bbBone.name = GSONUtils.get((JsonElement)jsonBone, "name", JsonElement::getAsString, "").toLowerCase(Locale.ENGLISH);
            GSONUtils.ifPresent(entry, "origin", origin -> {
                JsonArray originArray = origin.getAsJsonArray();
                bbBone.origin[0] = originArray.get(0).getAsFloat();
                bbBone.origin[1] = originArray.get(1).getAsFloat();
                bbBone.origin[2] = originArray.get(2).getAsFloat();
            });
            GSONUtils.ifPresent(entry, "rotation", rotation -> {
                JsonArray rotationArray = rotation.getAsJsonArray();
                bbBone.rotation[0] = rotationArray.get(0).getAsFloat();
                bbBone.rotation[1] = rotationArray.get(1).getAsFloat();
                bbBone.rotation[2] = rotationArray.get(2).getAsFloat();
            });
            bbBone.uuid = GSONUtils.get((JsonElement)jsonBone, "uuid", uuid -> UUID.fromString(uuid.getAsString()));
            bbBone.export = GSONUtils.get((JsonElement)jsonBone, "export", JsonElement::getAsBoolean, true);
            GSONUtils.ifPresent((JsonElement)jsonBone, "children", children -> this.readBones((JsonElement)children, bbBone.childBone, bbBone.element));
            bbBone.name = this.readOptions(bbBone);
            boneMap.put(bbBone.name, bbBone);
            this.boneCache.put(bbBone.uuid, bbBone);
        }
    }

    private String readOptions(BlockbenchModel.Bone bone) {
        if (!this.readOptions) {
            return bone.name;
        }
        String name = bone.name;
        Map<String, Map<String, Object>> options = bone.options;
        if (name.startsWith("h_")) {
            name = name.substring(2);
            options.put(BoneBehaviorTypes.HEAD.getId(), new HashMap());
        } else if (name.startsWith("hi_")) {
            name = name.substring(3);
            options.put(BoneBehaviorTypes.HEAD.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("inherited", true);
                }
            });
        }
        if (name.equals("mount")) {
            options.put(BoneBehaviorTypes.MOUNT.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("driver", true);
                }
            });
            return name;
        }
        if (name.startsWith("b_")) {
            options.put(BoneBehaviorTypes.SUB_HITBOX.getId(), new HashMap());
            return name;
        }
        if (name.startsWith("ob_")) {
            options.put(BoneBehaviorTypes.SUB_HITBOX.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("obb", true);
                }
            });
            return name;
        }
        String[] split = name.split("_");
        if (!bone.element.isEmpty()) {
            block48: for (int i = 0; i < split.length; ++i) {
                String tag;
                switch (tag = split[i]) {
                    case "seg": {
                        options.put(BoneBehaviorTypes.SEGMENT.getId(), new HashMap());
                        continue block48;
                    }
                    case "phead": {
                        options.put(BoneBehaviorTypes.PLAYER_LIMB.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                            {
                                this.put("limb", PlayerLimb.Limb.HEAD);
                            }
                        });
                        continue block48;
                    }
                    case "prarm": {
                        options.put(BoneBehaviorTypes.PLAYER_LIMB.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                            {
                                this.put("limb", PlayerLimb.Limb.RIGHT_ARM);
                            }
                        });
                        continue block48;
                    }
                    case "plarm": {
                        options.put(BoneBehaviorTypes.PLAYER_LIMB.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                            {
                                this.put("limb", PlayerLimb.Limb.LEFT_ARM);
                            }
                        });
                        continue block48;
                    }
                    case "pbody": {
                        options.put(BoneBehaviorTypes.PLAYER_LIMB.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                            {
                                this.put("limb", PlayerLimb.Limb.BODY);
                            }
                        });
                        continue block48;
                    }
                    case "prleg": {
                        options.put(BoneBehaviorTypes.PLAYER_LIMB.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                            {
                                this.put("limb", PlayerLimb.Limb.RIGHT_LEG);
                            }
                        });
                        continue block48;
                    }
                    case "plleg": {
                        options.put(BoneBehaviorTypes.PLAYER_LIMB.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                            {
                                this.put("limb", PlayerLimb.Limb.LEFT_LEG);
                            }
                        });
                        continue block48;
                    }
                    default: {
                        StringBuilder builder = new StringBuilder(tag);
                        for (int j = i + 1; j < split.length; ++j) {
                            builder.append("_").append(split[j]);
                        }
                        return builder.toString();
                    }
                }
            }
            return name;
        }
        block50: for (int i = 0; i < split.length; ++i) {
            String tag;
            switch (tag = split[i]) {
                case "g": {
                    options.put(BoneBehaviorTypes.GHOST.getId(), new HashMap());
                    continue block50;
                }
                case "tag": {
                    options.put(BoneBehaviorTypes.NAMETAG.getId(), new HashMap());
                    continue block50;
                }
                case "p": {
                    options.put(BoneBehaviorTypes.MOUNT.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                        {
                            this.put("driver", false);
                        }
                    });
                    continue block50;
                }
                case "ir": {
                    options.put(BoneBehaviorTypes.ITEM.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                        {
                            this.put("display", ItemDisplay.ItemDisplayTransform.THIRDPERSON_RIGHTHAND);
                        }
                    });
                    continue block50;
                }
                case "il": {
                    options.put(BoneBehaviorTypes.ITEM.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                        {
                            this.put("display", ItemDisplay.ItemDisplayTransform.THIRDPERSON_LEFTHAND);
                        }
                    });
                    continue block50;
                }
                case "ih": {
                    options.put(BoneBehaviorTypes.ITEM.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                        {
                            this.put("display", ItemDisplay.ItemDisplayTransform.HEAD);
                        }
                    });
                    continue block50;
                }
                case "l": {
                    options.put(BoneBehaviorTypes.LEASH.getId(), new HashMap());
                    continue block50;
                }
                case "phead": {
                    options.put(BoneBehaviorTypes.PLAYER_LIMB.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                        {
                            this.put("limb", PlayerLimb.Limb.HEAD);
                        }
                    });
                    continue block50;
                }
                case "prarm": {
                    options.put(BoneBehaviorTypes.PLAYER_LIMB.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                        {
                            this.put("limb", PlayerLimb.Limb.RIGHT_ARM);
                        }
                    });
                    continue block50;
                }
                case "plarm": {
                    options.put(BoneBehaviorTypes.PLAYER_LIMB.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                        {
                            this.put("limb", PlayerLimb.Limb.LEFT_ARM);
                        }
                    });
                    continue block50;
                }
                case "pbody": {
                    options.put(BoneBehaviorTypes.PLAYER_LIMB.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                        {
                            this.put("limb", PlayerLimb.Limb.BODY);
                        }
                    });
                    continue block50;
                }
                case "prleg": {
                    options.put(BoneBehaviorTypes.PLAYER_LIMB.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                        {
                            this.put("limb", PlayerLimb.Limb.RIGHT_LEG);
                        }
                    });
                    continue block50;
                }
                case "plleg": {
                    options.put(BoneBehaviorTypes.PLAYER_LIMB.getId(), (Map<String, Object>)new HashMap<String, Object>(){
                        {
                            this.put("limb", PlayerLimb.Limb.LEFT_LEG);
                        }
                    });
                    continue block50;
                }
                default: {
                    StringBuilder builder = new StringBuilder(tag);
                    for (int j = i + 1; j < split.length; ++j) {
                        builder.append("_").append(split[j]);
                    }
                    return builder.toString();
                }
            }
        }
        return name;
    }

    public BlockbenchDeserializer(Supplier<T> supplier, boolean readOptions) {
        this.supplier = supplier;
        this.readOptions = readOptions;
    }
}

