/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.mythic.mechanics.item;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.BoneBehaviorTypes;
import com.ticxo.modelengine.api.model.bone.type.HeldItem;
import com.ticxo.modelengine.core.mythic.MythicUtils;
import com.ticxo.modelengine.core.mythic.utils.MythicMechanic;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(name="setitemmodel", aliases={})
public class SetItemModelMechanic
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final PlaceholderString item;

    public SetItemModelMechanic(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mlc.getPlaceholderString(new String[]{"b", "bone", "p", "pid", "part", "partid"}, null, new String[0]);
        this.item = mlc.getPlaceholderString(new String[]{"i", "item"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String modelId = MythicUtils.getOrNullLowercase(this.modelId, (PlaceholderMeta)meta, target);
        model.getModel(modelId).ifPresent(activeModel -> {
            String partId = MythicUtils.getOrNullLowercase(this.partId, (PlaceholderMeta)meta, target);
            activeModel.getBone(partId).ifPresent(modelBone -> modelBone.getBoneBehavior(BoneBehaviorTypes.ITEM).ifPresent(heldItem -> {
                String item = MythicUtils.getOrNull(this.item, (PlaceholderMeta)meta, target);
                if (item == null) {
                    ((HeldItem)((Object)heldItem)).clearItemProvider();
                    return;
                }
                Optional maybeMMItem = MythicBukkit.inst().getItemManager().getItem(item);
                if (maybeMMItem.isPresent()) {
                    ItemStack stack = BukkitAdapter.adapt((AbstractItemStack)((MythicItem)maybeMMItem.get()).generateItemStack(1));
                    ((HeldItem)((Object)heldItem)).setItemProvider(new HeldItem.StaticItemStackSupplier(stack));
                    return;
                }
                Material mat = Material.getMaterial((String)item.toUpperCase(Locale.ENGLISH));
                if (mat == null) {
                    return;
                }
                ItemStack stack = new ItemStack(mat);
                ((HeldItem)((Object)heldItem)).setItemProvider(new HeldItem.StaticItemStackSupplier(stack));
            }));
        });
        return SkillResult.SUCCESS;
    }
}

