/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.v1_20_R1.parser.behavior;

import com.ticxo.modelengine.api.entity.data.IEntityData;
import com.ticxo.modelengine.api.model.bone.render.BehaviorRendererParser;
import com.ticxo.modelengine.api.model.bone.render.renderer.NameTagRenderer;
import com.ticxo.modelengine.v1_20_R1.entity.EntityUtils;
import com.ticxo.modelengine.v1_20_R1.network.utils.NetworkUtils;
import com.ticxo.modelengine.v1_20_R1.network.utils.Packets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.Player;
import org.joml.Vector3f;

public class NameTagParser
implements BehaviorRendererParser<NameTagRenderer> {
    @Override
    public void sendToClients(NameTagRenderer renderer) {
        IEntityData data = renderer.getModelRenderer().getActiveModel().getModeledEntity().getBase().getData();
        this.update(data.getTracking().keySet(), renderer);
        this.spawn(data.getStartTracking(), renderer);
        this.remove(data.getStopTracking(), renderer);
    }

    @Override
    public void destroy(NameTagRenderer renderer) {
        IEntityData data = renderer.getActiveModel().getModeledEntity().getBase().getData();
        HashSet<Player> inRange = new HashSet<Player>(data.getStartTracking());
        inRange.addAll(data.getTracking().keySet());
        inRange.addAll(data.getStopTracking());
        this.remove(inRange, renderer);
    }

    private void spawn(Set<Player> targets, NameTagRenderer renderer) {
        if (targets.isEmpty()) {
            return;
        }
        Packets set = new Packets();
        for (NameTagRenderer.NameTag nameTag : renderer.getRendered().values()) {
            set.add(this.pivotSpawn(nameTag));
            set.add((Packet<PacketListenerPlayOut>)this.pivotData(nameTag, true));
            set.add((Packet<PacketListenerPlayOut>)this.tagSpawn(nameTag));
            set.add((Packet<PacketListenerPlayOut>)this.tagData(nameTag, true));
            set.add((Packet<PacketListenerPlayOut>)this.pivotMount(nameTag));
        }
        for (NameTagRenderer.NameTag nameTag : renderer.getSpawnQueue().values()) {
            set.add(this.pivotSpawn(nameTag));
            set.add((Packet<PacketListenerPlayOut>)this.pivotData(nameTag, true));
            set.add((Packet<PacketListenerPlayOut>)this.tagSpawn(nameTag));
            set.add((Packet<PacketListenerPlayOut>)this.tagData(nameTag, true));
            set.add((Packet<PacketListenerPlayOut>)this.pivotMount(nameTag));
        }
        NetworkUtils.sendBundled(targets, set);
    }

    private void update(Set<Player> targets, NameTagRenderer renderer) {
        if (targets.isEmpty()) {
            return;
        }
        Packets set = new Packets();
        for (NameTagRenderer.NameTag nameTag : renderer.getRendered().values()) {
            set.add((Packet<PacketListenerPlayOut>)this.tagData(nameTag, false));
            if (!nameTag.getPosition().isDirty()) continue;
            set.add(this.pivotMove(nameTag));
            nameTag.getPosition().clearDirty();
        }
        for (NameTagRenderer.NameTag nameTag : renderer.getSpawnQueue().values()) {
            set.add(this.pivotSpawn(nameTag));
            set.add((Packet<PacketListenerPlayOut>)this.pivotData(nameTag, true));
            set.add((Packet<PacketListenerPlayOut>)this.tagSpawn(nameTag));
            set.add((Packet<PacketListenerPlayOut>)this.tagData(nameTag, true));
            set.add((Packet<PacketListenerPlayOut>)this.pivotMount(nameTag));
        }
        Map destroy = renderer.getDestroyQueue();
        if (!destroy.isEmpty()) {
            PacketDataSerializer buf = NetworkUtils.createByteBuf();
            buf.d(destroy.size() * 2);
            destroy.forEach((s, mount) -> {
                buf.d(mount.getPivotId());
                buf.d(mount.getTagId());
            });
            set.add((Packet<PacketListenerPlayOut>)new PacketPlayOutEntityDestroy(buf));
        }
        NetworkUtils.sendBundled(targets, set);
    }

    private void remove(Set<Player> targets, NameTagRenderer renderer) {
        if (targets.isEmpty()) {
            return;
        }
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        Collection<NameTagRenderer.NameTag> nameTags = renderer.getRendered().values();
        buf.d(nameTags.size() * 2);
        nameTags.forEach(nameTag -> {
            buf.d(nameTag.getPivotId());
            buf.d(nameTag.getTagId());
        });
        NetworkUtils.send(targets, (Packet<PacketListenerPlayOut>)new PacketPlayOutEntityDestroy(buf));
    }

    private Packets.PacketSupplier pivotSpawn(NameTagRenderer.NameTag renderer) {
        return NetworkUtils.createPivotSpawn(renderer.getPivotId(), renderer.getPivotUuid(), renderer.getPosition().get());
    }

    private PacketPlayOutEntityMetadata pivotData(NameTagRenderer.NameTag renderer, boolean spawn) {
        if (!spawn && !renderer.isDirty()) {
            return null;
        }
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        buf.d(renderer.getPivotId());
        if (spawn) {
            EntityUtils.writeData(buf, 0, DataWatcherRegistry.a, (byte)32);
            EntityUtils.writeData(buf, 1, DataWatcherRegistry.b, Integer.MAX_VALUE);
            EntityUtils.writeData(buf, 8, DataWatcherRegistry.d, Float.valueOf(0.0f));
        }
        buf.writeByte(255);
        renderer.clearDirty();
        return new PacketPlayOutEntityMetadata(buf);
    }

    private PacketPlayOutSpawnEntity tagSpawn(NameTagRenderer.NameTag renderer) {
        Vector3f pos = renderer.getPosition().get();
        return new PacketPlayOutSpawnEntity(renderer.getTagId(), renderer.getTagUuid(), (double)pos.x, (double)pos.y, (double)pos.z, 0.0f, 0.0f, EntityTypes.d, 0, Vec3D.b, 0.0);
    }

    private PacketPlayOutEntityMetadata tagData(NameTagRenderer.NameTag renderer, boolean spawn) {
        if (!spawn && !renderer.isDirty()) {
            return null;
        }
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        buf.d(renderer.getTagId());
        if (spawn) {
            EntityUtils.writeData(buf, 0, DataWatcherRegistry.a, (byte)32);
            EntityUtils.writeData(buf, 1, DataWatcherRegistry.b, Integer.MAX_VALUE);
            EntityUtils.writeData(buf, 15, DataWatcherRegistry.a, (byte)16);
        }
        renderer.getVisibility().ifDirty(flag -> EntityUtils.writeData(buf, 3, DataWatcherRegistry.k, flag), spawn);
        renderer.getJsonString().ifDirty(jsonString -> EntityUtils.writeData(buf, 2, DataWatcherRegistry.g, Optional.ofNullable(IChatBaseComponent.ChatSerializer.a((String)jsonString))), spawn);
        buf.writeByte(255);
        renderer.clearDirty();
        return new PacketPlayOutEntityMetadata(buf);
    }

    private Packets.PacketSupplier pivotMove(NameTagRenderer.NameTag renderer) {
        return NetworkUtils.createPivotTeleport(renderer.getPivotId(), renderer.getPosition().get());
    }

    private PacketPlayOutMount pivotMount(NameTagRenderer.NameTag renderer) {
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        buf.d(renderer.getPivotId());
        buf.d(1);
        buf.d(renderer.getTagId());
        return new PacketPlayOutMount(buf);
    }
}

