/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.v1_20_R2.entity.controller;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehavior;
import com.ticxo.modelengine.api.model.bone.manager.BehaviorManager;
import com.ticxo.modelengine.api.model.bone.manager.MountData;
import com.ticxo.modelengine.api.model.bone.manager.MountManager;
import com.ticxo.modelengine.api.model.bone.type.Mount;
import com.ticxo.modelengine.api.mount.controller.MountController;
import com.ticxo.modelengine.api.nms.entity.wrapper.MoveController;
import com.ticxo.modelengine.api.utils.ReflectionUtils;
import com.ticxo.modelengine.v1_20_R2.NMSFields;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.phys.Vec3D;
import org.apache.logging.log4j.util.TriConsumer;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftVector;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class MoveControlWrapper
extends ControllerMove
implements MoveController {
    protected final ControllerMove original;
    protected final Queue<Runnable> runnables = new ConcurrentLinkedQueue<Runnable>();
    protected boolean isOnGround;

    public MoveControlWrapper(EntityInsentient mob, ControllerMove control) {
        super(mob);
        this.original = control;
    }

    public boolean b() {
        return this.original.b();
    }

    public double c() {
        return this.original.c();
    }

    public void a(double x, double y, double z, double speed) {
        this.original.a(x, y, z, speed);
    }

    public void a(float forward, float sideways) {
        this.original.a(forward, sideways);
    }

    public void a() {
        BehaviorManager<? extends Mount> & MountManager mainMountManager;
        this.isOnGround = this.d.aA();
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(this.d.cv());
        if (modeledEntity == null) {
            this.defaultTick();
            return;
        }
        Object mountData = modeledEntity.getMountData();
        BehaviorManager<? extends Mount> & MountManager t = mainMountManager = mountData == null ? null : (BehaviorManager<? extends Mount> & MountManager)((MountData)mountData).getMainMountManager();
        if (mainMountManager != null && ((MountManager)mainMountManager).isControlled()) {
            this.d.c(true);
            this.disableWaterJumping();
            this.driverTick(mainMountManager);
        } else {
            this.defaultTick();
        }
        this.passengerTick(modeledEntity, mainMountManager);
        while (!this.runnables.isEmpty()) {
            this.runnables.poll().run();
        }
    }

    public double d() {
        return this.original.d();
    }

    public double e() {
        return this.original.e();
    }

    public double f() {
        return this.original.f();
    }

    protected <T extends BehaviorManager<? extends Mount> & MountManager> void driverTick(T manager) {
        this.d.A(0.0f);
        this.d.C(0.0f);
        this.updateRider(((MountManager)manager).getDriver(), manager.getActiveModel(), (Mount)((MountManager)manager).getDriverBone(), (TriConsumer<MountController, MoveController, ActiveModel>)((TriConsumer)MountController::updateDriverMovement));
    }

    protected <T extends BehaviorManager<? extends Mount> & MountManager> void passengerTick(ModeledEntity modeledEntity, T manager) {
        for (ActiveModel activeModel : modeledEntity.getModels().values()) {
            activeModel.getMountManager().ifPresent(mountManager -> {
                for (BoneBehavior seat : ((MountManager)((Object)mountManager)).getSeats().values()) {
                    for (Entity passenger : ((Mount)((Object)seat)).getPassengers()) {
                        this.updateRider(passenger, activeModel, (Mount)((Object)seat), (TriConsumer<MountController, MoveController, ActiveModel>)((TriConsumer)MountController::updatePassengerMovement));
                    }
                }
                if (mountManager != manager && ((MountManager)((Object)mountManager)).isControlled()) {
                    this.updateRider(((MountManager)((Object)mountManager)).getDriver(), activeModel, (Mount)((MountManager)((Object)mountManager)).getDriverBone(), (TriConsumer<MountController, MoveController, ActiveModel>)((TriConsumer)MountController::updatePassengerMovement));
                }
            });
        }
    }

    private void updateRider(Entity entity, ActiveModel activeModel, Mount mountBone, TriConsumer<MountController, MoveController, ActiveModel> updateMethod) {
        MountController controller = this.getController(entity.getUniqueId());
        if (controller == null) {
            return;
        }
        if (controller.getInput() == null) {
            controller.setInput(new MountController.MountInput());
        }
        updateMethod.accept((Object)controller, (Object)this, (Object)activeModel);
    }

    protected void defaultTick() {
        this.original.a();
    }

    private void disableWaterJumping() {
        if (this.d.aX()) {
            ReflectionUtils.set(this.d, NMSFields.LIVING_ENTITY_noJumpDelay, 1);
        }
    }

    @Override
    public void move(float side, float up, float front, float speedModifier) {
        float speed = this.getSpeed();
        this.d.w(speed * speedModifier);
        this.d.A(front);
        this.d.B(up);
        this.d.C(side);
    }

    @Override
    public void globalMove(float x, float y, float z, float speedModifier) {
        float speed = this.getSpeed();
        this.d.w(speed * speedModifier);
        Vec3D vec = new Vec3D((double)x, (double)y, (double)z).b(-this.d.dB() * ((float)Math.PI / 180));
        this.d.C((float)vec.c);
        this.d.B((float)vec.d);
        this.d.A((float)vec.e);
    }

    @Override
    public void jump() {
        this.d.K().a();
    }

    @Override
    public void setVelocity(double x, double y, double z) {
        this.d.o(x, y, z);
    }

    @Override
    public void addVelocity(double x, double y, double z) {
        this.d.f(this.d.do().b(x, y, z));
    }

    @Override
    public void nullifyFallDistance() {
        this.d.n();
    }

    @Override
    public boolean isOnGround() {
        return this.isOnGround;
    }

    @Override
    public boolean isInWater() {
        return this.d.aX();
    }

    @Override
    public float getSpeed() {
        return (float)this.d.b(GenericAttributes.d);
    }

    @Override
    public Vector getVelocity() {
        return CraftVector.toBukkit((Vec3D)this.d.do());
    }

    @Override
    public void queuePostTick(Runnable runnable) {
        this.runnables.add(runnable);
    }

    private MountController getController(UUID uuid) {
        return ModelEngineAPI.getMountPairManager().getController(uuid);
    }
}

