/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.math;

import java.util.UUID;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class TMath {
    public static final float PI = (float)Math.PI;
    public static final double TAU = Math.PI * 2;
    public static final double PI_2 = 1.5707963267948966;
    public static final double PI_4 = 0.7853981633974483;
    public static final double EPSILON = 1.0E-5;
    public static final float DEG2RAD = (float)Math.PI / 180;
    public static final float RAD2DEG = 57.29578f;
    protected static SlerpMode slerpMode = SlerpMode.SLERP;
    protected static double movementResolution = 0.001;

    public static boolean isSimilar(float a, float b2) {
        return (double)org.joml.Math.abs((float)(b2 - a)) < 1.0E-5;
    }

    public static double clamp(double value, double min, double max) {
        return org.joml.Math.min((double)org.joml.Math.max((double)value, (double)min), (double)max);
    }

    public static float clamp(float value, float min, float max) {
        return org.joml.Math.min((float)org.joml.Math.max((float)value, (float)min), (float)max);
    }

    public static int clamp(int value, int min, int max) {
        return org.joml.Math.min((int)org.joml.Math.max((int)value, (int)min), (int)max);
    }

    public static int absMax(float a, float b2, float c2) {
        float absA = org.joml.Math.abs((float)a);
        float absB = org.joml.Math.abs((float)b2);
        float absC = org.joml.Math.abs((float)c2);
        if (absA > absB) {
            if (absA > absC) {
                return 0;
            }
            return 2;
        }
        if (absB > absC) {
            return 1;
        }
        return 2;
    }

    public static byte setBit(byte dataItem, int bitOffset, boolean flag) {
        byte f = (byte)(1 << bitOffset);
        return (byte)(flag ? dataItem | f : dataItem & ~f);
    }

    public static boolean getBit(byte dataItem, int bitOffset) {
        return (dataItem & 1 << bitOffset) != 0;
    }

    public static int floor(double val) {
        return (int)org.joml.Math.floor((double)val);
    }

    public static int ceil(double val) {
        return (int)org.joml.Math.ceil((double)val);
    }

    public static double tryParse(String val, double def) {
        if (val == null) {
            return def;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException ignored) {
            return def;
        }
    }

    public static boolean isBoundingBoxWithinDistance(@NotNull Vector start, @NotNull Vector direction, BoundingBox boundingBox, double maxDistance) {
        double tzMax;
        double tzMin;
        double tyMax;
        double tyMin;
        double tMax;
        double tMin;
        double startX = start.getX();
        double startY = start.getY();
        double startZ = start.getZ();
        Vector dir = direction.clone();
        if (dir.getX() == 0.0) {
            dir.setX(0);
        }
        if (dir.getY() == 0.0) {
            dir.setY(0);
        }
        if (dir.getZ() == 0.0) {
            dir.setZ(0);
        }
        dir.normalize();
        double dirX = dir.getX();
        double dirY = dir.getY();
        double dirZ = dir.getZ();
        double divX = 1.0 / dirX;
        double divY = 1.0 / dirY;
        double divZ = 1.0 / dirZ;
        if (dirX >= 0.0) {
            tMin = (boundingBox.getMinX() - startX) * divX;
            tMax = (boundingBox.getMaxX() - startX) * divX;
        } else {
            tMin = (boundingBox.getMaxX() - startX) * divX;
            tMax = (boundingBox.getMinX() - startX) * divX;
        }
        if (dirY >= 0.0) {
            tyMin = (boundingBox.getMinY() - startY) * divY;
            tyMax = (boundingBox.getMaxY() - startY) * divY;
        } else {
            tyMin = (boundingBox.getMaxY() - startY) * divY;
            tyMax = (boundingBox.getMinY() - startY) * divY;
        }
        if (tMin > tyMax || tMax < tyMin) {
            return false;
        }
        if (tyMin > tMin) {
            tMin = tyMin;
        }
        if (tyMax < tMax) {
            tMax = tyMax;
        }
        if (dirZ >= 0.0) {
            tzMin = (boundingBox.getMinZ() - startZ) * divZ;
            tzMax = (boundingBox.getMaxZ() - startZ) * divZ;
        } else {
            tzMin = (boundingBox.getMaxZ() - startZ) * divZ;
            tzMax = (boundingBox.getMinZ() - startZ) * divZ;
        }
        if (tMin > tzMax || tMax < tzMin) {
            return false;
        }
        if (tzMin > tMin) {
            tMin = tzMin;
        }
        if (tzMax < tMax) {
            tMax = tzMax;
        }
        if (tMax < 0.0) {
            return false;
        }
        return !(tMin > maxDistance);
    }

    public static boolean isSimilar(Vector a, Vector b2) {
        return org.joml.Math.abs((double)(b2.getX() - a.getX())) < movementResolution && org.joml.Math.abs((double)(b2.getY() - a.getY())) < movementResolution && org.joml.Math.abs((double)(b2.getZ() - a.getZ())) < movementResolution;
    }

    public static EulerAngle makeAngle(double x, double y, double z) {
        return new EulerAngle(org.joml.Math.toRadians((double)x), org.joml.Math.toRadians((double)y), org.joml.Math.toRadians((double)z));
    }

    public static EulerAngle add(EulerAngle a, EulerAngle b2) {
        return a.add(b2.getX(), b2.getY(), b2.getZ());
    }

    public static float wrapRadian(float r) {
        if ((double)(r = (float)((double)r % (Math.PI * 2))) < -Math.PI) {
            r = (float)((double)r + Math.PI * 2);
        }
        if ((double)r > Math.PI) {
            r = (float)((double)r - Math.PI * 2);
        }
        return r;
    }

    public static float wrapDegree(float r) {
        if ((r %= 360.0f) < -180.0f) {
            r += 360.0f;
        }
        if (r > 180.0f) {
            r -= 360.0f;
        }
        return r;
    }

    public static float radianDifference(float a, float b2) {
        return TMath.wrapRadian(b2 - a);
    }

    public static float degreeDifference(float a, float b2) {
        return TMath.wrapDegree(b2 - a);
    }

    public static float rotateIfNecessary(float current, float target, float negativeClamp, float positiveClamp) {
        float delta = TMath.degreeDifference(current, target);
        float clampedDelta = TMath.clamp(delta, negativeClamp, positiveClamp);
        return target - clampedDelta;
    }

    public static byte rotToByte(float rot) {
        return (byte)(rot * 256.0f / 360.0f);
    }

    public static float byteToRot(byte rot) {
        return (float)rot / 256.0f * 360.0f;
    }

    public static double lerp(double a, double b2, double t) {
        return (1.0 - t) * a + t * b2;
    }

    public static double lerp(double a, double b2, double aT, double bT) {
        return aT * a + bT * b2;
    }

    public static float lerp(float a, float b2, float aT, float bT) {
        return aT * a + bT * b2;
    }

    public static double rotLerp(double a, double b2, double t) {
        return a + (double)TMath.degreeDifference((float)a, (float)b2) * t;
    }

    public static float rotLerp(float a, float b2, double t) {
        return (float)((double)a + (double)TMath.degreeDifference(a, b2) * t);
    }

    public static double smoothLerp(double a, double b2, double c2, double d, double t) {
        double t0 = 0.0;
        double t1 = 1.0;
        double t2 = 2.0;
        double t3 = 3.0;
        t = (t2 - t1) * t + t1;
        double a1 = TMath.lerp(a, b2, (t1 - t) / (t1 - t0), (t - t0) / (t1 - t0));
        double a2 = TMath.lerp(b2, c2, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
        double a3 = TMath.lerp(c2, d, (t3 - t) / (t3 - t2), (t - t2) / (t3 - t2));
        double b1 = TMath.lerp(a1, a2, (t2 - t) / (t2 - t0), (t - t0) / (t2 - t0));
        double b22 = TMath.lerp(a2, a3, (t3 - t) / (t3 - t1), (t - t1) / (t3 - t1));
        return TMath.lerp(b1, b22, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
    }

    public static Vector lerp(Vector a, Vector b2, double t) {
        return new Vector(TMath.lerp(a.getX(), b2.getX(), t), TMath.lerp(a.getY(), b2.getY(), t), TMath.lerp(a.getZ(), b2.getZ(), t));
    }

    public static Vector lerp(Vector a, Vector b2, double aT, double bT) {
        return new Vector(TMath.lerp(a.getX(), b2.getX(), aT, bT), TMath.lerp(a.getY(), b2.getY(), aT, bT), TMath.lerp(a.getZ(), b2.getZ(), aT, bT));
    }

    public static Vector3f lerp(Vector3f a, Vector3f b2, double t) {
        return new Vector3f((float)TMath.lerp(a.x, b2.x, t), (float)TMath.lerp(a.y, b2.y, t), (float)TMath.lerp(a.z, b2.z, t));
    }

    public static Vector3f lerp(Vector3f a, Vector3f b2, float aT, float bT) {
        return new Vector3f(TMath.lerp(a.x, b2.x, aT, bT), TMath.lerp(a.y, b2.y, aT, bT), TMath.lerp(a.z, b2.z, aT, bT));
    }

    public static Vector smoothLerp(Vector a, Vector b2, Vector c2, Vector d, double t) {
        double t0 = 0.0;
        double t1 = 1.0;
        double t2 = 2.0;
        double t3 = 3.0;
        t = (t2 - t1) * t + t1;
        Vector a1 = TMath.lerp(a, b2, (t1 - t) / (t1 - t0), (t - t0) / (t1 - t0));
        Vector a2 = TMath.lerp(b2, c2, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
        Vector a3 = TMath.lerp(c2, d, (t3 - t) / (t3 - t2), (t - t2) / (t3 - t2));
        Vector b1 = TMath.lerp(a1, a2, (t2 - t) / (t2 - t0), (t - t0) / (t2 - t0));
        Vector b22 = TMath.lerp(a2, a3, (t3 - t) / (t3 - t1), (t - t1) / (t3 - t1));
        return TMath.lerp(b1, b22, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
    }

    public static Vector3f smoothLerp(Vector3f a, Vector3f b2, Vector3f c2, Vector3f d, float t) {
        float t0 = 0.0f;
        float t1 = 1.0f;
        float t2 = 2.0f;
        float t3 = 3.0f;
        t = (t2 - t1) * t + t1;
        Vector3f a1 = TMath.lerp(a, b2, (t1 - t) / (t1 - t0), (t - t0) / (t1 - t0));
        Vector3f a2 = TMath.lerp(b2, c2, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
        Vector3f a3 = TMath.lerp(c2, d, (t3 - t) / (t3 - t2), (t - t2) / (t3 - t2));
        Vector3f b1 = TMath.lerp(a1, a2, (t2 - t) / (t2 - t0), (t - t0) / (t2 - t0));
        Vector3f b22 = TMath.lerp(a2, a3, (t3 - t) / (t3 - t1), (t - t1) / (t3 - t1));
        return TMath.lerp(b1, b22, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
    }

    public static EulerAngle lerp(EulerAngle a, EulerAngle b2, double t) {
        return new EulerAngle(TMath.lerp(a.getX(), b2.getX(), t), TMath.lerp(a.getY(), b2.getY(), t), TMath.lerp(a.getZ(), b2.getZ(), t));
    }

    public static EulerAngle lerp(EulerAngle a, EulerAngle b2, double aT, double bT) {
        return new EulerAngle(TMath.lerp(a.getX(), b2.getX(), aT, bT), TMath.lerp(a.getY(), b2.getY(), aT, bT), TMath.lerp(a.getZ(), b2.getZ(), aT, bT));
    }

    public static EulerAngle smoothLerp(EulerAngle a, EulerAngle b2, EulerAngle c2, EulerAngle d, double t) {
        double t0 = 0.0;
        double t1 = 1.0;
        double t2 = 2.0;
        double t3 = 3.0;
        t = (t2 - t1) * t + t1;
        EulerAngle a1 = TMath.lerp(a, b2, (t1 - t) / (t1 - t0), (t - t0) / (t1 - t0));
        EulerAngle a2 = TMath.lerp(b2, c2, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
        EulerAngle a3 = TMath.lerp(c2, d, (t3 - t) / (t3 - t2), (t - t2) / (t3 - t2));
        EulerAngle b1 = TMath.lerp(a1, a2, (t2 - t) / (t2 - t0), (t - t0) / (t2 - t0));
        EulerAngle b22 = TMath.lerp(a2, a3, (t3 - t) / (t3 - t1), (t - t1) / (t3 - t1));
        return TMath.lerp(b1, b22, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
    }

    public static Vector3f slerp(Vector3f a, Vector3f b2, double t) {
        if (a.equals((Object)b2)) {
            return a;
        }
        Quaternionf qA = new Quaternionf().rotationZYX(a.z, a.y, a.x);
        Quaternionf qB = new Quaternionf().rotationZYX(b2.z, b2.y, b2.x);
        qA.slerp((Quaternionfc)qB, (float)t);
        return TMath.getEulerAnglesZYX(qA, new Vector3f());
    }

    public static Vector3f getEulerAnglesZYX(Quaternionf quaternionf, Vector3f eulerAngles) {
        float w = quaternionf.w;
        float x = quaternionf.x;
        float y = quaternionf.y;
        float z = quaternionf.z;
        eulerAngles.x = org.joml.Math.atan2((float)(2.0f * (y * z + x * w)), (float)(z * z - y * y - x * x + w * w));
        eulerAngles.y = org.joml.Math.safeAsin((float)(-2.0f * (x * z - w * y)));
        eulerAngles.z = org.joml.Math.atan2((float)(x * y + w * z), (float)(0.5f - y * y - z * z));
        return eulerAngles;
    }

    public static Vector3d getEulerAnglesZYX(Quaterniond quaterniond, Vector3d eulerAngles) {
        double w = quaterniond.w;
        double x = quaterniond.x;
        double y = quaterniond.y;
        double z = quaterniond.z;
        eulerAngles.x = org.joml.Math.atan2((double)(2.0 * (y * z + x * w)), (double)(z * z - y * y - x * x + w * w));
        eulerAngles.y = org.joml.Math.safeAsin((double)(-2.0 * (x * z - w * y)));
        eulerAngles.z = org.joml.Math.atan2((double)(x * y + w * z), (double)(0.5 - y * y - z * z));
        return eulerAngles;
    }

    public static String toString(EulerAngle angle) {
        return String.format("[%s, %s, %s]", org.joml.Math.toDegrees((double)angle.getX()), org.joml.Math.toDegrees((double)angle.getY()), org.joml.Math.toDegrees((double)angle.getZ()));
    }

    public static UUID parseUUID(String uuid) {
        try {
            return UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            if (uuid.length() != 32) {
                throw e;
            }
            long first = Long.parseUnsignedLong(uuid.substring(0, 16), 16);
            long last = Long.parseUnsignedLong(uuid.substring(16), 16);
            return new UUID(first, last);
        }
    }

    public static enum SlerpMode {
        SLERP,
        ONLERP;


        public static SlerpMode get(String name) {
            try {
                return SlerpMode.valueOf(name);
            }
            catch (IllegalArgumentException ignored) {
                return SLERP;
            }
        }
    }
}

