/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.generator.parser.modelengine.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.ticxo.modelengine.api.utils.data.GSONUtils;
import com.ticxo.modelengine.core.generator.parser.modelengine.json.ModelEngineExtraData;
import java.lang.reflect.Type;
import java.util.UUID;
import org.joml.Vector3f;

public class ModelEngineDeserializer
implements JsonDeserializer<ModelEngineExtraData> {
    public ModelEngineExtraData deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        ModelEngineExtraData data = new ModelEngineExtraData();
        GSONUtils.ifPresent(jsonElement, "modelEngineFormatMeta", meta -> GSONUtils.ifPresent(meta, "boneProperties", propertiesElement -> {
            if (propertiesElement.isJsonObject()) {
                JsonObject properties = propertiesElement.getAsJsonObject();
                for (String id : properties.keySet()) {
                    String propertyType;
                    String propertyBehavior;
                    UUID uuid = UUID.fromString(id);
                    JsonObject dataObject = properties.getAsJsonObject(id);
                    ModelEngineExtraData.BoneProperty boneProperty = new ModelEngineExtraData.BoneProperty();
                    boneProperty.renderByDefault = GSONUtils.get((JsonElement)dataObject, "renderByDefault", JsonElement::getAsBoolean, true);
                    boneProperty.dupeTarget = GSONUtils.get((JsonElement)dataObject, "copyModel", copyId -> UUID.fromString(copyId.getAsString()));
                    GSONUtils.ifPresent((JsonElement)dataObject, "copyScale", from -> {
                        JsonArray array = from.getAsJsonArray();
                        boneProperty.boneScale = new Vector3f(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat());
                    });
                    switch (propertyBehavior = GSONUtils.get((JsonElement)dataObject, "boneBehavior", JsonElement::getAsString, "")) {
                        case "head": {
                            boneProperty.behaviors.add(ModelEngineExtraData.Behavior.HEAD);
                            break;
                        }
                        case "segment": {
                            boneProperty.behaviors.add(ModelEngineExtraData.Behavior.SEGMENT);
                        }
                    }
                    block12 : switch (propertyType = GSONUtils.get((JsonElement)dataObject, "type", JsonElement::getAsString, "bone")) {
                        case "hitbox": {
                            Boolean orientated = GSONUtils.get((JsonElement)dataObject, "orientated", JsonElement::getAsBoolean, false);
                            boneProperty.behaviors.add(orientated != false ? ModelEngineExtraData.Behavior.SUB_OBB : ModelEngineExtraData.Behavior.SUB_AABB);
                            break;
                        }
                        case "seat": {
                            Boolean driver = GSONUtils.get((JsonElement)dataObject, "driver", JsonElement::getAsBoolean, false);
                            boneProperty.behaviors.add(driver != false ? ModelEngineExtraData.Behavior.DRIVER : ModelEngineExtraData.Behavior.PASSENGER);
                            break;
                        }
                        default: {
                            String boneOption;
                            switch (boneOption = GSONUtils.get((JsonElement)dataObject, "boneOptions", JsonElement::getAsString, "")) {
                                case "ghost": {
                                    boneProperty.behaviors.add(ModelEngineExtraData.Behavior.GHOST);
                                    break block12;
                                }
                                case "leash": {
                                    boneProperty.behaviors.add(ModelEngineExtraData.Behavior.LEASH);
                                    break block12;
                                }
                                case "nametag": {
                                    boneProperty.behaviors.add(ModelEngineExtraData.Behavior.NAMETAG);
                                    break block12;
                                }
                                case "item_model": {
                                    String itemPosition;
                                    switch (itemPosition = GSONUtils.get((JsonElement)dataObject, "itemPosition", JsonElement::getAsString, "head")) {
                                        case "head": {
                                            boneProperty.behaviors.add(ModelEngineExtraData.Behavior.ITEM_HEAD);
                                            break block12;
                                        }
                                        case "rightArm": {
                                            boneProperty.behaviors.add(ModelEngineExtraData.Behavior.ITEM_RIGHT);
                                            break block12;
                                        }
                                        case "leftArm": {
                                            boneProperty.behaviors.add(ModelEngineExtraData.Behavior.ITEM_LEFT);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    GSONUtils.ifArray((JsonElement)dataObject, "customOptions", custom -> {
                        String customId = GSONUtils.get(custom, "name", JsonElement::getAsString, "");
                        String customValue = GSONUtils.get(custom, "value", JsonElement::getAsString, "");
                        Boolean customEnabled = GSONUtils.get(custom, "enabled", JsonElement::getAsBoolean, true);
                        ModelEngineExtraData.CustomOption customOption = new ModelEngineExtraData.CustomOption(customId, customValue, customEnabled);
                        boneProperty.getCustomOptions().add(customOption);
                    });
                    data.getBoneProperties().put(uuid, boneProperty);
                }
            }
        }));
        return data;
    }
}

