/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.entity.Hitbox;
import com.ticxo.modelengine.api.events.AddModelEvent;
import com.ticxo.modelengine.api.events.RemoveModelEvent;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.BoneBehaviorTypes;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehavior;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehaviorType;
import com.ticxo.modelengine.api.model.bone.behavior.GlobalBehaviorData;
import com.ticxo.modelengine.api.model.bone.manager.MountData;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import com.ticxo.modelengine.api.utils.data.io.SavedData;
import com.ticxo.modelengine.api.utils.data.tracker.DataTracker;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.core.model.ActiveModelImpl;
import com.ticxo.modelengine.core.model.bone.manager.MountDataImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ModeledEntityImpl
implements ModeledEntity {
    private final BaseEntity<?> base;
    private final Map<String, ActiveModel> models = Maps.newConcurrentMap();
    private final Map<BoneBehaviorType<?>, GlobalBehaviorData> data = Maps.newConcurrentMap();
    private final boolean initialized;
    private final List<Runnable> queuedTask = new ArrayList<Runnable>();
    private final DataTracker<Float> trueYHeadRot = new DataTracker<Float>(TMath::isSimilar);
    private final DataTracker<Float> trueXHeadRot = new DataTracker<Float>(TMath::isSimilar);
    private final DataTracker<Float> trueYBodyRot = new DataTracker<Float>(TMath::isSimilar);
    private int tick;
    private boolean isBaseEntityVisible = true;
    private boolean destroyed;
    private boolean removed;
    private int hurtTick = 0;
    private boolean isModelRotationLocked;
    private int rotationTick = -1;
    private float yHeadRot = 0.0f;
    private float xHeadRot = 0.0f;
    private float yBodyRot = 0.0f;
    private boolean shouldSave = true;
    private ActiveModel lastHitboxOverride = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModeledEntityImpl(@NotNull BaseEntity<?> base, @Nullable Consumer<ModeledEntity> consumer) {
        this.base = base;
        this.registerSelf();
        if (consumer != null) {
            consumer.accept(this);
        }
        List<Runnable> list = this.queuedTask;
        synchronized (list) {
            this.queuedTask.forEach(Runnable::run);
            this.initialized = true;
        }
    }

    @Override
    public boolean tick() {
        if (!this.initialized) {
            return true;
        }
        if (this.hurtTick > 0) {
            --this.hurtTick;
        }
        if (!this.isModelRotationLocked && this.base.isAlive()) {
            BodyRotationController bodyRotationController = this.base.getBodyRotationController();
            bodyRotationController.tick();
            this.trueYHeadRot.set(Float.valueOf(bodyRotationController.getYHeadRot()));
            this.trueXHeadRot.set(Float.valueOf(bodyRotationController.getXHeadRot()));
            this.trueYBodyRot.set(Float.valueOf(bodyRotationController.getYBodyRot()));
            if (this.rotationTick == -1) {
                this.yHeadRot = this.trueYHeadRot.get().floatValue();
                this.xHeadRot = this.trueXHeadRot.get().floatValue();
                this.yBodyRot = this.trueYBodyRot.get().floatValue();
                this.rotationTick = 0;
            }
            if (!this.base.isWalking()) {
                this.yBodyRot = this.trueYBodyRot.get().floatValue();
            }
            if (this.trueYHeadRot.isDirty() || this.trueXHeadRot.isDirty() || this.trueYBodyRot.isDirty()) {
                this.rotationTick = 3;
                this.trueYHeadRot.clearDirty();
                this.trueXHeadRot.clearDirty();
                this.trueYBodyRot.clearDirty();
            }
            if (this.rotationTick > 0) {
                this.yHeadRot = TMath.rotLerp(this.yHeadRot, this.trueYHeadRot.get().floatValue(), (double)(1.0f / (float)this.rotationTick));
                this.xHeadRot = TMath.rotLerp(this.xHeadRot, this.trueXHeadRot.get().floatValue(), (double)(1.0f / (float)this.rotationTick));
                this.yBodyRot = TMath.rotLerp(this.yBodyRot, this.trueYBodyRot.get().floatValue(), (double)(1.0f / (float)this.rotationTick));
                --this.rotationTick;
            }
        }
        boolean hasFinished = true;
        for (ActiveModel model : this.models.values()) {
            model.tick();
            if (!hasFinished) continue;
            hasFinished = model.getAnimationHandler().hasFinishedAllAnimations();
        }
        this.base.setForcedAlive(!hasFinished);
        ++this.tick;
        return !this.removed && !this.base.isRemoved() && (this.base.isAlive() || !hasFinished && !this.base.getData().getTracking().isEmpty());
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        this.models.forEach((s, model) -> model.destroy());
        this.models.clear();
    }

    @Override
    public void markRemoved() {
        this.removed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queuePostInitTask(Runnable runnable) {
        List<Runnable> list = this.queuedTask;
        synchronized (list) {
            if (this.initialized) {
                runnable.run();
            } else {
                this.queuedTask.add(runnable);
            }
        }
    }

    @Override
    public void setBaseEntityVisible(boolean flag) {
        if (this.isBaseEntityVisible() == flag) {
            return;
        }
        this.isBaseEntityVisible = flag;
        this.base.setVisible(flag);
    }

    @Override
    public void markHurt() {
        this.hurtTick = 10;
    }

    @Override
    public boolean shouldBeSaved() {
        return this.shouldSave;
    }

    @Override
    public void setSaved(boolean flag) {
        this.shouldSave = flag;
    }

    @Override
    public Optional<ActiveModel> addModel(@NotNull ActiveModel model, boolean overrideHitbox) {
        assert (!this.isDestroyed()) : "Modeled Entity has been destroyed!";
        assert (model.getModeledEntity() == null || model.isRemoved()) : "Active Model already belongs to a different Modeled Entity";
        AddModelEvent event = new AddModelEvent(this, model);
        event.setOverrideHitbox(overrideHitbox);
        ModelEngineAPI.callEvent(event);
        if (event.isCancelled()) {
            return Optional.empty();
        }
        model.setRemoved(false);
        model.setModeledEntity(this);
        model.generateModel();
        Optional<ActiveModel> previous = this.removeModel(model.getBlueprint().getName());
        this.models.put(model.getBlueprint().getName(), model);
        model.getMountManager().ifPresent(mountManager -> {
            Object mountData = this.getMountData();
            if (((MountData)mountData).getMainMountManager() == null) {
                ((MountData)mountData).setMainMountManager(mountManager);
            }
        });
        if (overrideHitbox) {
            if (this.lastHitboxOverride != null) {
                this.lastHitboxOverride.setMainHitbox(false);
            }
            model.setMainHitbox(true);
            this.lastHitboxOverride = model;
            Hitbox mainHitbox = model.getBlueprint().getMainHitbox();
            Vector3f scale = model.getScale();
            Hitbox scaledRenderHitbox = new Hitbox(mainHitbox.getWidth() * (double)scale.x, mainHitbox.getHeight() * (double)scale.y, mainHitbox.getDepth() * (double)scale.z, mainHitbox.getEyeHeight() * (double)scale.y);
            this.base.getData().setCullHitbox(scaledRenderHitbox);
            Object obj = this.base.getOriginal();
            if (obj instanceof Entity) {
                Entity entity = (Entity)obj;
                Vector3f hitboxScale = model.getHitboxScale();
                Hitbox scaledHitbox = new Hitbox(mainHitbox.getWidth() * (double)hitboxScale.x, mainHitbox.getHeight() * (double)hitboxScale.y, mainHitbox.getDepth() * (double)hitboxScale.z, mainHitbox.getEyeHeight() * (double)hitboxScale.y);
                ModelEngineAPI.getEntityHandler().setHitbox(entity, scaledHitbox);
            }
        }
        return previous;
    }

    @Override
    public Optional<ActiveModel> removeModel(String id) {
        assert (!this.isDestroyed()) : "Modeled Entity has been destroyed!";
        ActiveModel model = this.models.get(id);
        if (model == null) {
            return Optional.empty();
        }
        RemoveModelEvent event = new RemoveModelEvent(this, model);
        ModelEngineAPI.callEvent(event);
        if (event.isCancelled()) {
            return Optional.empty();
        }
        this.models.remove(id);
        model.setRemoved(true);
        return Optional.of(model);
    }

    @Override
    public Optional<ActiveModel> getModel(@Nullable String id) {
        return Optional.ofNullable(id == null ? null : this.models.get(id));
    }

    @Override
    public Map<String, ActiveModel> getModels() {
        return ImmutableMap.copyOf(this.models);
    }

    @Override
    public <T extends BoneBehavior> GlobalBehaviorData getOrCreateGlobalBehaviorData(BoneBehaviorType<T> type, Supplier<GlobalBehaviorData> supplier) {
        return this.data.computeIfAbsent(type, boneBehaviorType -> (GlobalBehaviorData)supplier.get());
    }

    @Override
    public <T extends BoneBehavior> GlobalBehaviorData getGlobalBehaviorData(BoneBehaviorType<T> type) {
        return this.data.get(type);
    }

    @Override
    public <T extends BoneBehavior> GlobalBehaviorData removeGlobalBehaviorData(BoneBehaviorType<T> type) {
        return this.data.remove(type);
    }

    @Override
    public Map<BoneBehaviorType<?>, GlobalBehaviorData> getAllGlobalBehaviorData(BoneBehaviorType<?> type) {
        return ImmutableMap.copyOf(this.data);
    }

    @Override
    public <T extends GlobalBehaviorData & MountData> T getMountData() {
        return (T)this.getOrCreateGlobalBehaviorData(BoneBehaviorTypes.MOUNT, MountDataImpl::new);
    }

    @Override
    public void save(SavedData data) {
        data.putString("version", "R4.0.3");
        data.putBoolean("base_visible", this.isBaseEntityVisible());
        data.putBoolean("rotation_locked", this.isModelRotationLocked());
        ArrayList list = new ArrayList();
        for (ActiveModel activeModel : this.models.values()) {
            activeModel.save().ifPresent(list::add);
        }
        data.putList("models", list);
        this.base.save().ifPresent(entityData -> data.putData("base_entity", (SavedData)entityData));
    }

    @Override
    public void load(SavedData data) {
        this.setBaseEntityVisible(data.getBoolean("base_visible"));
        this.setModelRotationLocked(data.getBoolean("rotation_locked"));
        List<SavedData> list = data.getList("models", SavedData.class);
        for (SavedData modelData : list) {
            ActiveModel model = ActiveModelImpl.fromData(modelData);
            if (model == null) continue;
            model.setAutoRendererInitialization(false);
            model.load(modelData);
            this.addModel(model, model.isMainHitbox()).ifPresent(ActiveModel::destroy);
            model.initializeRenderer();
        }
        data.getData("base_entity").ifPresent(this.base::load);
    }

    @Override
    public BaseEntity<?> getBase() {
        return this.base;
    }

    public Map<BoneBehaviorType<?>, GlobalBehaviorData> getData() {
        return this.data;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public List<Runnable> getQueuedTask() {
        return this.queuedTask;
    }

    public DataTracker<Float> getTrueYHeadRot() {
        return this.trueYHeadRot;
    }

    public DataTracker<Float> getTrueXHeadRot() {
        return this.trueXHeadRot;
    }

    public DataTracker<Float> getTrueYBodyRot() {
        return this.trueYBodyRot;
    }

    @Override
    public int getTick() {
        return this.tick;
    }

    @Override
    public boolean isBaseEntityVisible() {
        return this.isBaseEntityVisible;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public int getHurtTick() {
        return this.hurtTick;
    }

    @Override
    public boolean isModelRotationLocked() {
        return this.isModelRotationLocked;
    }

    public int getRotationTick() {
        return this.rotationTick;
    }

    @Override
    public float getYHeadRot() {
        return this.yHeadRot;
    }

    @Override
    public float getXHeadRot() {
        return this.xHeadRot;
    }

    @Override
    public float getYBodyRot() {
        return this.yBodyRot;
    }

    public boolean isShouldSave() {
        return this.shouldSave;
    }

    public ActiveModel getLastHitboxOverride() {
        return this.lastHitboxOverride;
    }

    @Override
    public void setModelRotationLocked(boolean isModelRotationLocked) {
        this.isModelRotationLocked = isModelRotationLocked;
    }
}

