/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.v1_20_R3.network.utils;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.nms.network.ProtectedPacket;
import com.ticxo.modelengine.v1_20_R3.network.NetworkHandlerImpl;
import com.ticxo.modelengine.v1_20_R3.network.utils.Packets;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class NetworkUtils {
    public static PacketDataSerializer createByteBuf() {
        return new PacketDataSerializer(Unpooled.buffer());
    }

    public static PacketDataSerializer readData(Packet<?> packet) {
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        packet.a(buf);
        return buf;
    }

    public static Packets.PacketSupplier createPivotSpawn(int id, UUID uuid, Vector3f pos) {
        return player -> ModelEngineAPI.getPlayerProtocolVersion(player.getUniqueId()) >= 764 ? new PacketPlayOutSpawnEntity(id, uuid, (double)pos.x, (double)pos.y - 0.5, (double)pos.z, 0.0f, 0.0f, EntityTypes.c, 0, Vec3D.b, 0.0) : new PacketPlayOutSpawnEntity(id, uuid, (double)pos.x, (double)pos.y - 0.375, (double)pos.z, 0.0f, 0.0f, EntityTypes.c, 0, Vec3D.b, 0.0);
    }

    public static Packets.PacketSupplier createPivotTeleport(int id, Vector3f pos) {
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        buf.c(id);
        buf.a((double)pos.x);
        buf.a((double)pos.y - 0.375);
        buf.a((double)pos.z);
        buf.k(0);
        buf.k(0);
        buf.a(false);
        PacketPlayOutEntityTeleport tpHigher = new PacketPlayOutEntityTeleport(buf);
        buf = NetworkUtils.createByteBuf();
        buf.c(id);
        buf.a((double)pos.x);
        buf.a((double)pos.y - 0.5);
        buf.a((double)pos.z);
        buf.k(0);
        buf.k(0);
        buf.a(false);
        PacketPlayOutEntityTeleport tpLower = new PacketPlayOutEntityTeleport(buf);
        return player -> ModelEngineAPI.getPlayerProtocolVersion(player.getUniqueId()) >= 764 ? tpLower : tpHigher;
    }

    public static void send(Player target, @Nullable Packet<PacketListenerPlayOut> packet) {
        if (packet == null) {
            return;
        }
        NetworkHandlerImpl handler = NetworkHandlerImpl.instance;
        if (handler.isBatching()) {
            handler.appendPacket(target.getUniqueId(), packet);
        } else {
            ProtectedPacket wrapped = new ProtectedPacket(packet);
            ModelEngineAPI.getNetworkHandler().getPipeline(target).ifPresent(pipeline -> pipeline.writeAndFlush((Object)wrapped));
        }
    }

    public static void send(Set<Player> targets, @Nullable Packet<PacketListenerPlayOut> packet) {
        if (packet == null) {
            return;
        }
        NetworkHandlerImpl handler = NetworkHandlerImpl.instance;
        if (handler.isBatching()) {
            for (Player player : targets) {
                handler.appendPacket(player.getUniqueId(), packet);
            }
        } else {
            ProtectedPacket wrapped = new ProtectedPacket(packet);
            for (Player player : targets) {
                ModelEngineAPI.getNetworkHandler().getPipeline(player).ifPresent(pipeline -> pipeline.writeAndFlush((Object)wrapped));
            }
        }
    }

    public static void send(Set<Player> targets, @Nullable Packet<PacketListenerPlayOut> packet, Predicate<Player> predicate) {
        if (packet == null) {
            return;
        }
        NetworkHandlerImpl handler = NetworkHandlerImpl.instance;
        if (handler.isBatching()) {
            for (Player player : targets) {
                if (!predicate.test(player)) continue;
                handler.appendPacket(player.getUniqueId(), packet);
            }
        } else {
            ProtectedPacket wrapped = new ProtectedPacket(packet);
            for (Player player : targets) {
                if (!predicate.test(player)) continue;
                ModelEngineAPI.getNetworkHandler().getPipeline(player).ifPresent(pipeline -> pipeline.writeAndFlush((Object)wrapped));
            }
        }
    }

    public static void sendRaw(Player target, @Nullable Packet<PacketListenerPlayOut> packet) {
        if (packet == null) {
            return;
        }
        ModelEngineAPI.getNetworkHandler().getPipeline(target).ifPresent(pipeline -> pipeline.writeAndFlush((Object)packet));
    }

    public static void sendRaw(Set<Player> targets, @Nullable Packet<PacketListenerPlayOut> packet) {
        if (packet == null) {
            return;
        }
        for (Player player : targets) {
            ModelEngineAPI.getNetworkHandler().getPipeline(player).ifPresent(pipeline -> pipeline.writeAndFlush((Object)packet));
        }
    }

    public static void sendRaw(Set<Player> targets, @Nullable Packet<PacketListenerPlayOut> packet, Predicate<Player> predicate) {
        if (packet == null) {
            return;
        }
        for (Player player : targets) {
            if (!predicate.test(player)) continue;
            ModelEngineAPI.getNetworkHandler().getPipeline(player).ifPresent(pipeline -> pipeline.writeAndFlush((Object)packet));
        }
    }

    public static void sendBundled(Player target, Packets collection) {
        if (collection.isEmpty()) {
            return;
        }
        Collection<Packet<PacketListenerPlayOut>> packets = collection.compile(target);
        NetworkHandlerImpl handler = NetworkHandlerImpl.instance;
        if (handler.isBatching()) {
            handler.appendPackets(target.getUniqueId(), packets);
        } else {
            ProtectedPacket wrapped = new ProtectedPacket(new ClientboundBundlePacket(packets));
            handler.getPipeline(target).ifPresent(pipeline -> pipeline.writeAndFlush((Object)wrapped));
        }
    }

    public static void sendBundled(Set<Player> targets, Packets collection) {
        if (collection.isEmpty()) {
            return;
        }
        NetworkHandlerImpl handler = NetworkHandlerImpl.instance;
        if (handler.isBatching()) {
            for (Player player : targets) {
                handler.appendPackets(player.getUniqueId(), collection.compile(player));
            }
        } else {
            for (Player player : targets) {
                ModelEngineAPI.getNetworkHandler().getPipeline(player).ifPresent(pipeline -> {
                    ProtectedPacket wrapped = new ProtectedPacket(new ClientboundBundlePacket(collection.compile(player)));
                    pipeline.writeAndFlush((Object)wrapped);
                });
            }
        }
    }

    public static void sendBundled(Set<Player> targets, Packets collection, Predicate<Player> predicate) {
        if (collection.isEmpty()) {
            return;
        }
        NetworkHandlerImpl handler = NetworkHandlerImpl.instance;
        if (handler.isBatching()) {
            for (Player player : targets) {
                if (!predicate.test(player)) continue;
                handler.appendPackets(player.getUniqueId(), collection.compile(player));
            }
        } else {
            for (Player player : targets) {
                if (!predicate.test(player)) continue;
                ModelEngineAPI.getNetworkHandler().getPipeline(player).ifPresent(pipeline -> {
                    ProtectedPacket wrapped = new ProtectedPacket(new ClientboundBundlePacket(collection.compile(player)));
                    pipeline.writeAndFlush((Object)wrapped);
                });
            }
        }
    }

    public static void sendBundledRaw(Player target, Packets collection) {
        if (collection.isEmpty()) {
            return;
        }
        ClientboundBundlePacket packet = new ClientboundBundlePacket(collection.compile(target));
        ModelEngineAPI.getNetworkHandler().getPipeline(target).ifPresent(pipeline -> pipeline.writeAndFlush((Object)packet));
    }

    public static void sendBundledRaw(Set<Player> targets, Packets collection) {
        if (collection.isEmpty()) {
            return;
        }
        for (Player player : targets) {
            ModelEngineAPI.getNetworkHandler().getPipeline(player).ifPresent(pipeline -> {
                ClientboundBundlePacket packet = new ClientboundBundlePacket(collection.compile(player));
                pipeline.writeAndFlush((Object)packet);
            });
        }
    }

    public static void sendBundledRaw(Set<Player> targets, Packets collection, Predicate<Player> predicate) {
        if (collection.isEmpty()) {
            return;
        }
        for (Player player : targets) {
            if (!predicate.test(player)) continue;
            ModelEngineAPI.getNetworkHandler().getPipeline(player).ifPresent(pipeline -> {
                ClientboundBundlePacket packet = new ClientboundBundlePacket(collection.compile(player));
                pipeline.writeAndFlush((Object)packet);
            });
        }
    }
}

