/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.crafting.uifilters;

import io.lumine.mythic.lib.api.crafting.ingredients.MythicIngredient;
import io.lumine.mythic.lib.api.crafting.ingredients.MythicRecipeIngredient;
import io.lumine.mythic.lib.api.crafting.ingredients.MythicRecipeInventory;
import io.lumine.mythic.lib.api.crafting.recipes.MythicCraftingManager;
import io.lumine.mythic.lib.api.crafting.recipes.MythicRecipe;
import io.lumine.mythic.lib.api.crafting.recipes.ShapelessRecipe;
import io.lumine.mythic.lib.api.crafting.uifilters.UIFilter;
import io.lumine.mythic.lib.api.crafting.uimanager.UIFilterManager;
import io.lumine.mythic.lib.api.util.ItemFactory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.QuickNumberRange;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import io.lumine.mythic.lib.version.VersionMaterial;
import java.util.ArrayList;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeUIFilter
implements UIFilter {
    static RecipeUIFilter global;

    @Override
    @NotNull
    public String getIdentifier() {
        return "r";
    }

    @NotNull
    static ItemStack getFromInventory(@NotNull Inventory inven, int slot) {
        ItemStack target = inven.getItem(slot);
        if (target == null) {
            target = VersionMaterial.CAULDRON.toItem();
        }
        return target;
    }

    @Override
    public boolean matches(@NotNull Inventory inventory, int targetSlot, int width, int height, @NotNull String argument, @NotNull String data, @Nullable QuickNumberRange amount, @Nullable FriendlyFeedbackProvider ffp) {
        if (!this.isValid(argument, data, ffp)) {
            return false;
        }
        if (this.cancelMatch(RecipeUIFilter.getFromInventory(inventory, targetSlot), ffp)) {
            return false;
        }
        MythicRecipe recipe = MythicCraftingManager.getLoadedRecipe(argument);
        MythicRecipeInventory extract = new MythicRecipeInventory();
        for (int h = 0; h < height; ++h) {
            ItemStack[] row = new ItemStack[width];
            for (int w = 0; w < width; ++w) {
                int current = targetSlot + w + h * width;
                if (inventory.getSize() <= current) continue;
                ItemStack found = inventory.getItem(current);
                if (found != null) {
                    found = found.clone();
                }
                row[w] = found;
            }
            extract.addRow(row);
        }
        return recipe.matches(extract, null) != null;
    }

    @Override
    public boolean matches(@NotNull ItemStack item, @NotNull String argument, @NotNull String data, @Nullable FriendlyFeedbackProvider ffp) {
        this.cancelMatch(item, ffp);
        return false;
    }

    @Override
    public boolean isValid(@NotNull String argument, @NotNull String data, @Nullable FriendlyFeedbackProvider ffp) {
        return MythicCraftingManager.getLoadedRecipe(argument) != null;
    }

    @Override
    @NotNull
    public ArrayList<String> tabCompleteArgument(@NotNull String current) {
        return SilentNumbers.smartFilter(MythicCraftingManager.getLoadedRecipes(), current, true);
    }

    @Override
    @NotNull
    public ArrayList<String> tabCompleteData(@NotNull String argument, @NotNull String current) {
        return SilentNumbers.toArrayList("0", "(this_is_not_checked,_write_anything)");
    }

    @Override
    public boolean fullyDefinesItem() {
        return false;
    }

    @Override
    public boolean useInventoryMatch() {
        return true;
    }

    @Override
    @Nullable
    public ItemStack getItemStack(@NotNull String argument, @NotNull String data, @Nullable FriendlyFeedbackProvider ffp) {
        return null;
    }

    @Override
    @NotNull
    public ItemStack getDisplayStack(@NotNull String argument, @NotNull String data, @Nullable FriendlyFeedbackProvider ffp) {
        return ItemFactory.of(Material.CRAFTING_TABLE).name("\u00a7aMythicRecipe \u00a7e " + argument).lore(this.getDescription(argument, data)).build();
    }

    @Override
    @NotNull
    public ArrayList<String> getDescription(@NotNull String argument, @NotNull String data) {
        if (!this.isValid(argument, data, null)) {
            return SilentNumbers.toArrayList("Recipe '$u" + argument + "$b' is $finvalid$b.");
        }
        return SilentNumbers.chop("Checks that the area contains the shaped recipe \u00a7b\u00a7o" + argument + "\u00a77\u00a7o in correct order and amounts.", 55, "\u00a77\u00a7o");
    }

    @Override
    public boolean determinateGeneration() {
        return true;
    }

    @Override
    @NotNull
    public String getSourcePlugin() {
        return "MythicLib";
    }

    @Override
    @NotNull
    public String getFilterName() {
        return "MythicRecipe";
    }

    @Override
    @NotNull
    public String exampleArgument() {
        return "mysterious_sample_recipe";
    }

    @Override
    @NotNull
    public String exampleData() {
        return "0";
    }

    public static void register() {
        MythicIngredient ingredient = MythicIngredient.get("wood_planks");
        Validate.isTrue((ingredient != null ? 1 : 0) != 0, (String)"RecipeUIFilter must enable after the IngredientUIFilter does, so that we can use that ingredient.");
        ShapelessRecipe recipe = new ShapelessRecipe("mysterious_sample_recipe", new MythicRecipeIngredient(ingredient));
        recipe.load();
        global = new RecipeUIFilter();
        UIFilterManager.registerUIFilter(global);
        recipe.unload();
    }

    @NotNull
    public static RecipeUIFilter get() {
        return global;
    }
}

