/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.crafting.uifilters;

import io.lumine.mythic.lib.api.crafting.uimanager.ProvidedUIFilter;
import io.lumine.mythic.lib.api.crafting.uimanager.UIFilterCountermatch;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.QuickNumberRange;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface UIFilter {
    @NotNull
    public static final HashMap<String, ArrayList<UIFilterCountermatch>> matchOverrides = new HashMap();

    @NotNull
    public String getIdentifier();

    default public boolean matches(@NotNull Inventory inventory, int targetSlot, int width, int height, @NotNull String argument, @NotNull String data, @Nullable QuickNumberRange amount, @Nullable FriendlyFeedbackProvider ffp) {
        int itemAmount;
        ItemStack item = inventory.getItem(targetSlot);
        if (item == null) {
            item = new ItemStack(Material.AIR);
        }
        if (!ProvidedUIFilter.checkAmount(amount, itemAmount = item.getAmount())) {
            FriendlyFeedbackProvider.log(ffp, FriendlyFeedbackCategory.FAILURE, "The amount of this item ($u{0}$b) was $fnot the desired $b({1}$b). ", String.valueOf(itemAmount), amount.toStringColored());
            return false;
        }
        return this.matches(item, argument, data, ffp);
    }

    public boolean matches(@NotNull ItemStack var1, @NotNull String var2, @NotNull String var3, @Nullable FriendlyFeedbackProvider var4);

    public boolean isValid(@NotNull String var1, @NotNull String var2, @Nullable FriendlyFeedbackProvider var3);

    @NotNull
    public ArrayList<String> tabCompleteArgument(@NotNull String var1);

    @NotNull
    public ArrayList<String> tabCompleteData(@NotNull String var1, @NotNull String var2);

    public boolean fullyDefinesItem();

    default public boolean useInventoryMatch() {
        return false;
    }

    @Nullable
    public ItemStack getItemStack(@NotNull String var1, @NotNull String var2, @Nullable FriendlyFeedbackProvider var3);

    @NotNull
    public ItemStack getDisplayStack(@NotNull String var1, @NotNull String var2, @Nullable FriendlyFeedbackProvider var3);

    @NotNull
    public ArrayList<String> getDescription(@NotNull String var1, @NotNull String var2);

    default public boolean determinateGeneration() {
        return true;
    }

    default public boolean partialDeterminateGeneration(@NotNull String argument, @NotNull String data) {
        return this.determinateGeneration();
    }

    default public void addMatchOverride(@NotNull UIFilterCountermatch countermatch) {
        matchOverrides.put(this.getIdentifier(), SilentNumbers.addAll(matchOverrides.get(this.getIdentifier()), countermatch));
    }

    default public boolean cancelMatch(@NotNull ItemStack item, @Nullable FriendlyFeedbackProvider ffp) {
        matchOverrides.computeIfAbsent(this.getIdentifier(), k -> new ArrayList());
        boolean failure = false;
        for (UIFilterCountermatch ufc : matchOverrides.get(this.getIdentifier())) {
            boolean thisPrevent;
            int e = 0;
            if (ffp != null) {
                ffp.messagesTotal();
            }
            boolean bl = failure = (thisPrevent = ufc.preventsMatching(item, ffp)) || failure;
            if (!thisPrevent || ffp == null || ffp.messagesTotal() != e) continue;
            ffp.log(FriendlyFeedbackCategory.ERROR, "Item match was cancelled by $f{0}$b for an unspecified reason.", ufc.getClass().getPackage().getName() + "." + ufc.getClass().getSimpleName());
        }
        return failure;
    }

    @NotNull
    public String getSourcePlugin();

    @NotNull
    public String getFilterName();

    @NotNull
    public String exampleArgument();

    @NotNull
    public String exampleData();
}

