/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.player;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.comp.flags.CustomFlag;
import io.lumine.mythic.lib.damage.AttackMetadata;
import io.lumine.mythic.lib.player.PlayerMetadata;
import io.lumine.mythic.lib.player.cooldown.CooldownMap;
import io.lumine.mythic.lib.player.cooldown.CooldownType;
import io.lumine.mythic.lib.player.particle.ParticleEffectMap;
import io.lumine.mythic.lib.player.potion.PermanentPotionEffectMap;
import io.lumine.mythic.lib.player.skill.PassiveSkill;
import io.lumine.mythic.lib.player.skill.PassiveSkillMap;
import io.lumine.mythic.lib.script.variable.VariableList;
import io.lumine.mythic.lib.script.variable.VariableScope;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.trigger.TriggerMetadata;
import io.lumine.mythic.lib.skill.trigger.TriggerType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.lang.Validate;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MMOPlayerData {
    private final UUID uuid;
    @Nullable
    private Player player;
    private long lastLogActivity;
    private final CooldownMap cooldownMap = new CooldownMap();
    private final StatMap statMap = new StatMap(this);
    private final PermanentPotionEffectMap permEffectMap = new PermanentPotionEffectMap(this);
    private final ParticleEffectMap particleEffectMap = new ParticleEffectMap(this);
    private final PassiveSkillMap passiveSkillMap = new PassiveSkillMap(this);
    private final VariableList variableList = new VariableList(VariableScope.PLAYER);
    private final Map<String, Object> externalData = new HashMap<String, Object>();
    private static final long CACHE_TIME_OUT = 86400000L;
    private static final Map<UUID, MMOPlayerData> data = new HashMap<UUID, MMOPlayerData>();

    private MMOPlayerData(Player player) {
        this.uuid = player.getUniqueId();
        this.player = player;
    }

    public MMOPlayerData(UUID uuid) {
        this.uuid = uuid;
        this.player = null;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public StatMap getStatMap() {
        return this.statMap;
    }

    @Deprecated
    public PermanentPotionEffectMap getPermanentEffectMap() {
        return this.permEffectMap;
    }

    @Deprecated
    public ParticleEffectMap getParticleEffectMap() {
        return this.particleEffectMap;
    }

    public PassiveSkillMap getPassiveSkillMap() {
        return this.passiveSkillMap;
    }

    public void triggerSkills(@NotNull TriggerType triggerType, @Nullable Entity target) {
        Validate.isTrue((!triggerType.isActionHandSpecific() ? 1 : 0) != 0, (String)"You must provide an action hand");
        this.triggerSkills(triggerType, EquipmentSlot.MAIN_HAND, target);
    }

    public void triggerSkills(@NotNull TriggerType triggerType, @NotNull EquipmentSlot actionHand, @Nullable Entity target) {
        Validate.notNull((Object)((Object)actionHand), (String)"Action hand cannot be null");
        this.triggerSkills(triggerType, this.statMap.cache(actionHand), target);
    }

    @Deprecated
    public void triggerSkills(@NotNull TriggerType triggerType, @NotNull PlayerMetadata caster, @Nullable AttackMetadata attackMetadata, @Nullable Entity target) {
        Collection<PassiveSkill> cast = triggerType.isActionHandSpecific() ? this.passiveSkillMap.isolateModifiers(caster.getActionHand()) : this.passiveSkillMap.getModifiers();
        this.triggerSkills(triggerType, caster, target, cast);
    }

    public void triggerSkills(@NotNull TriggerType triggerType, @NotNull PlayerMetadata caster, @Nullable Entity target) {
        Collection<PassiveSkill> cast = triggerType.isActionHandSpecific() ? this.passiveSkillMap.isolateModifiers(caster.getActionHand()) : this.passiveSkillMap.getModifiers();
        this.triggerSkills(triggerType, caster, target, cast);
    }

    @Deprecated
    public void triggerSkills(@NotNull TriggerType triggerType, @NotNull PlayerMetadata caster, @Nullable AttackMetadata attackMetadata, @Nullable Entity target, @NotNull Iterable<PassiveSkill> skills) {
        this.triggerSkills(triggerType, caster, target, skills);
    }

    public void triggerSkills(@NotNull TriggerType triggerType, @NotNull PlayerMetadata caster, @Nullable Entity target, @NotNull Iterable<PassiveSkill> skills) {
        if (this.getPlayer().getGameMode() == GameMode.SPECTATOR || !MythicLib.plugin.getFlags().isFlagAllowed(this.getPlayer(), CustomFlag.MMO_ABILITIES)) {
            return;
        }
        TriggerMetadata triggerMeta = new TriggerMetadata(caster, target);
        for (PassiveSkill skill : skills) {
            SkillHandler<?> handler = skill.getTriggeredSkill().getHandler();
            if (!handler.isTriggerable() || !skill.getType().equals(triggerType)) continue;
            skill.getTriggeredSkill().cast(triggerMeta);
        }
    }

    public VariableList getVariableList() {
        return this.variableList;
    }

    @Deprecated
    public long getLastLogin() {
        return this.getLastLogActivity();
    }

    public long getLastLogActivity() {
        return this.lastLogActivity;
    }

    public boolean isTimedOut() {
        return !this.isOnline() && this.lastLogActivity + 86400000L < System.currentTimeMillis();
    }

    public boolean isOnline() {
        return this.player != null;
    }

    @NotNull
    public Player getPlayer() {
        return Objects.requireNonNull(this.player, "Player is offline");
    }

    public void updatePlayer(@Nullable Player player) {
        this.player = player;
        this.lastLogActivity = System.currentTimeMillis();
    }

    public void applyCooldown(CooldownType cd, double value) {
        this.cooldownMap.applyCooldown(cd.name(), value);
    }

    public boolean isOnCooldown(CooldownType cd) {
        return this.cooldownMap.isOnCooldown(cd.name());
    }

    public CooldownMap getCooldownMap() {
        return this.cooldownMap;
    }

    @Nullable
    public <T> T getExternalData(String key, Class<T> objectType) {
        @Nullable Object found = this.externalData.get(key);
        return (T)(found == null ? null : found);
    }

    public void setExternalData(String key, Object obj) {
        this.externalData.put(key, obj);
    }

    public boolean hasExternalData(String key) {
        return this.externalData.containsKey(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MMOPlayerData)) {
            return false;
        }
        MMOPlayerData that = (MMOPlayerData)o;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public static MMOPlayerData setup(Player player) {
        @Nullable MMOPlayerData found = data.get(player.getUniqueId());
        if (found == null) {
            MMOPlayerData playerData = new MMOPlayerData(player);
            data.put(player.getUniqueId(), playerData);
            return playerData;
        }
        found.updatePlayer(player);
        return found;
    }

    @Deprecated
    public static boolean isLoaded(UUID uuid) {
        return MMOPlayerData.has(uuid);
    }

    @NotNull
    public static MMOPlayerData get(@NotNull OfflinePlayer player) {
        return MMOPlayerData.get(player.getUniqueId());
    }

    @NotNull
    public static MMOPlayerData get(UUID uuid) {
        return Objects.requireNonNull(data.get(uuid), "Player data not loaded");
    }

    @Nullable
    public static MMOPlayerData getOrNull(UUID uuid) {
        return data.get(uuid);
    }

    public static boolean has(Player player) {
        return MMOPlayerData.has(player.getUniqueId());
    }

    public static boolean has(UUID uuid) {
        return data.containsKey(uuid);
    }

    public static Collection<MMOPlayerData> getLoaded() {
        return data.values();
    }

    public static void forEachOnline(Consumer<MMOPlayerData> action) {
        for (MMOPlayerData registered : data.values()) {
            if (!registered.isOnline()) continue;
            action.accept(registered);
        }
    }

    public static void flushOfflinePlayerData() {
        Iterator<MMOPlayerData> iterator = data.values().iterator();
        while (iterator.hasNext()) {
            MMOPlayerData tempData = iterator.next();
            if (!tempData.isTimedOut()) continue;
            iterator.remove();
        }
    }
}

