/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.stat.handler;

import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.stat.StatInstance;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.api.stat.handler.StatHandler;
import io.lumine.mythic.lib.player.modifier.ModifierSource;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;

public class AttributeStatHandler
implements StatHandler {
    private final Attribute attribute;
    private final String stat;
    private final boolean meleeWeaponStat;

    public AttributeStatHandler(Attribute attribute, String stat) {
        this(attribute, stat, false);
    }

    public AttributeStatHandler(Attribute attribute, String stat, boolean meleeWeaponStat) {
        this.attribute = attribute;
        this.stat = stat;
        this.meleeWeaponStat = meleeWeaponStat;
    }

    @Override
    public void runUpdate(StatMap stats) {
        AttributeInstance attrIns = stats.getPlayerData().getPlayer().getAttribute(this.attribute);
        this.removeModifiers(attrIns);
        StatInstance statIns = stats.getInstance(this.stat);
        double mmo = statIns.getFilteredTotal(mod -> !(this.meleeWeaponStat && mod.getSource() == ModifierSource.RANGED_WEAPON || mod.getSource().isWeapon() && mod.getSlot() == EquipmentSlot.OFF_HAND));
        double base = this.getBaseValue(stats);
        if (mmo != base) {
            attrIns.addModifier(new AttributeModifier("mythiclib.main", mmo - base, AttributeModifier.Operation.ADD_NUMBER));
        }
    }

    @Override
    public double getTotalValue(StatMap map) {
        return map.getPlayerData().getPlayer().getAttribute(this.attribute).getValue();
    }

    @Override
    public double getBaseValue(StatMap map) {
        return map.getPlayerData().getPlayer().getAttribute(this.attribute).getBaseValue();
    }
}

