/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.gui;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.explorer.ChatInput;
import io.lumine.mythic.lib.api.explorer.ItemBuilder;
import io.lumine.mythic.lib.gui.AttributeExplorer;
import io.lumine.mythic.lib.gui.PluginInventory;
import io.lumine.mythic.lib.version.VersionMaterial;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class AttributeCreator
extends PluginInventory {
    private final AttributeExplorer explorer;
    private String name;
    private double amount;
    private AttributeModifier.Operation operation;
    private EquipmentSlot slot;
    private UUID uuid;

    public AttributeCreator(AttributeExplorer inv) {
        super(inv.getPlayer());
        this.explorer = inv;
    }

    @Override
    public Inventory getInventory() {
        Inventory inv = Bukkit.createInventory((InventoryHolder)this, (int)36, (String)"Attribute Creation..");
        inv.setItem(10, (ItemStack)new ItemBuilder(VersionMaterial.OAK_SIGN.toMaterial(), "&6Name").setLore("", "&7Current Value: &6" + (this.name == null ? "None" : this.name)));
        inv.setItem(11, (ItemStack)new ItemBuilder(Material.CHEST, "&6Amount").setLore("", "&7Current Value: &6" + this.amount));
        inv.setItem(12, (ItemStack)new ItemBuilder(Material.REPEATER, "&6Operation").setLore("", "&7Current Value: &6" + (this.operation == null ? "None" : this.operation.name())));
        inv.setItem(14, (ItemStack)new ItemBuilder(Material.LEATHER_HELMET, "&6Slot").setLore("", "&7Current Value: &6" + (this.slot == null ? "None" : this.slot.name())));
        inv.setItem(15, (ItemStack)new ItemBuilder(Material.NAME_TAG, "&6ID").setLore("", "&7Current Value: &6" + (this.uuid == null ? "None" : this.uuid.toString())));
        inv.setItem(30, (ItemStack)new ItemBuilder(Material.BARRIER, "&6\u21e8 Back"));
        inv.setItem(32, (ItemStack)new ItemBuilder(Material.GREEN_TERRACOTTA, "&aAdd Attribute!"));
        return inv;
    }

    @Override
    public void whenClicked(InventoryClickEvent event) {
        event.setCancelled(true);
        if (!event.getInventory().equals(event.getClickedInventory())) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (!UtilityMethods.isMetaItem(item)) {
            return;
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GOLD + "\u21e8" + " Back")) {
            this.explorer.open();
        } else if (item.getItemMeta().getDisplayName().equals(ChatColor.GREEN + "Add Attribute!")) {
            if (this.name == null) {
                this.getPlayer().sendMessage(ChatColor.RED + "> You must specify an attribute name!");
                return;
            }
            if (this.amount == 0.0) {
                this.getPlayer().sendMessage(ChatColor.RED + "> You must specify a valid amount!");
                return;
            }
            this.explorer.getTarget().getAttribute(this.explorer.getExplored()).addModifier(new AttributeModifier(this.uuid == null ? UUID.randomUUID() : this.uuid, this.name, this.amount, this.operation == null ? AttributeModifier.Operation.ADD_NUMBER : this.operation, this.slot));
            this.explorer.open();
            this.getPlayer().sendMessage(ChatColor.YELLOW + "> Attribute successfully added.");
        } else if (item.getItemMeta().getDisplayName().equals(ChatColor.GOLD + "Name")) {
            this.getPlayer().closeInventory();
            this.getPlayer().sendMessage(ChatColor.YELLOW + "> Write in the chat the name you want. Type 'cancel' to abort.");
            new ChatInput(this.getPlayer(), output -> {
                if (output == null) {
                    this.open();
                    return true;
                }
                this.name = output;
                this.getPlayer().sendMessage(ChatColor.YELLOW + "> Name set to " + ChatColor.GOLD + this.name + ChatColor.YELLOW + ".");
                this.open();
                return true;
            });
        } else if (item.getItemMeta().getDisplayName().equals(ChatColor.GOLD + "ID")) {
            this.getPlayer().closeInventory();
            this.getPlayer().sendMessage(ChatColor.YELLOW + "> Write in the chat the UUID you want.");
            new ChatInput(this.getPlayer(), output -> {
                if (output == null) {
                    this.open();
                    return true;
                }
                try {
                    this.uuid = UUID.fromString(output);
                    this.getPlayer().sendMessage(ChatColor.YELLOW + "> ID set to " + ChatColor.GOLD + output + ChatColor.YELLOW + ".");
                    this.open();
                    return true;
                }
                catch (IllegalArgumentException exception) {
                    this.getPlayer().sendMessage(ChatColor.RED + "> " + output + " is not a valid UUID. Type 'cancel' to cancel.");
                    return false;
                }
            });
        } else if (item.getItemMeta().getDisplayName().equals(ChatColor.GOLD + "Slot")) {
            this.getPlayer().closeInventory();
            this.getPlayer().sendMessage(ChatColor.YELLOW + "> Write in the slot name.");
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                this.getPlayer().sendMessage(ChatColor.YELLOW + "- " + slot.name().toLowerCase());
            }
            new ChatInput(this.getPlayer(), output -> {
                if (output == null) {
                    this.open();
                    return true;
                }
                String format = output.toUpperCase().replace(" ", "_").replace("-", "_");
                try {
                    this.slot = EquipmentSlot.valueOf((String)format);
                    this.getPlayer().sendMessage(ChatColor.YELLOW + "> Slot set to " + ChatColor.GOLD + format + ChatColor.YELLOW + ".");
                    this.open();
                    return true;
                }
                catch (IllegalArgumentException exception) {
                    this.getPlayer().sendMessage(ChatColor.RED + "> " + format + " is not a valid slot name. Type 'cancel' to cancel.");
                    return false;
                }
            });
        } else if (item.getItemMeta().getDisplayName().equals(ChatColor.GOLD + "Operation")) {
            this.getPlayer().closeInventory();
            this.getPlayer().sendMessage(ChatColor.YELLOW + "> Write in the operation name.");
            for (AttributeModifier.Operation operation : AttributeModifier.Operation.values()) {
                this.getPlayer().sendMessage(ChatColor.YELLOW + "- " + operation.name().toLowerCase());
            }
            new ChatInput(this.getPlayer(), output -> {
                if (output == null) {
                    this.open();
                    return true;
                }
                String format = output.toUpperCase().replace(" ", "_").replace("-", "_");
                try {
                    this.operation = AttributeModifier.Operation.valueOf((String)format);
                    this.getPlayer().sendMessage(ChatColor.YELLOW + "> Operation set to " + ChatColor.GOLD + format + ChatColor.YELLOW + ".");
                    this.open();
                    return true;
                }
                catch (IllegalArgumentException exception) {
                    this.getPlayer().sendMessage(ChatColor.RED + "> " + format + " is not a valid operation name. Type 'cancel' to cancel.");
                    return false;
                }
            });
        } else if (item.getItemMeta().getDisplayName().equals(ChatColor.GOLD + "Amount")) {
            this.getPlayer().closeInventory();
            this.getPlayer().sendMessage(ChatColor.YELLOW + "> Write in the chat the amount you want.");
            new ChatInput(this.getPlayer(), output -> {
                if (output == null) {
                    this.open();
                    return true;
                }
                try {
                    double d;
                    this.amount = d = Double.parseDouble(output);
                    this.getPlayer().sendMessage(ChatColor.YELLOW + "> Value set to " + ChatColor.GOLD + AttributeExplorer.FORMAT.format(d) + ChatColor.YELLOW + ".");
                    this.open();
                    return true;
                }
                catch (NumberFormatException exception) {
                    this.getPlayer().sendMessage(ChatColor.RED + "> " + output + " is not a valid number. Type 'cancel' to cancel.");
                    return false;
                }
            });
        }
    }
}

