/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.gui;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.explorer.AttributeData;
import io.lumine.mythic.lib.api.explorer.ChatInput;
import io.lumine.mythic.lib.api.explorer.ItemBuilder;
import io.lumine.mythic.lib.gui.AttributeCreator;
import io.lumine.mythic.lib.gui.PluginInventory;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AttributeExplorer
extends PluginInventory {
    private final Player target;
    private Attribute explored;
    private List<AttributeModifier> modifiers;
    private int page;
    private static final int[] SLOTS = new int[]{8, 17, 26, 35, 44, 53, 7, 16, 25, 34, 43, 52};
    private static final int[] MOD_SLOTS = new int[]{19, 20, 21, 22, 23, 28, 29, 30, 31, 32, 37, 38, 39, 40, 41};
    private static final Map<String, AttributeData> ATTRIBUTES = new HashMap<String, AttributeData>();
    public static final DecimalFormat FORMAT = new DecimalFormat("0.#####");

    public AttributeExplorer(Player player, Player target) {
        super(player);
        Validate.notNull((Object)target, (String)"Target cannot be null");
        this.target = target;
    }

    public Attribute getExplored() {
        return this.explored;
    }

    public Player getTarget() {
        return this.target;
    }

    @Override
    public Inventory getInventory() {
        Inventory inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)(this.explored == null ? "Attributes from " + this.target.getName() : "Exploring: " + this.getName(this.explored) + " (" + (this.page + 1) + ")"));
        inv.setItem(3, (ItemStack)new ItemBuilder(Material.WHITE_BED, "&6Refresh &8(Click)"));
        int j = 0;
        for (Attribute attribute : Attribute.values()) {
            String key;
            AttributeInstance ins = this.target.getAttribute(attribute);
            if (ins == null || !ATTRIBUTES.containsKey(key = attribute.name().substring("GENERIC_".length()))) continue;
            AttributeData data = ATTRIBUTES.get(key);
            ItemStack item = data.getIcon();
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(ChatColor.GOLD + ">> " + this.getName(attribute));
            meta.addItemFlags(ItemFlag.values());
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GRAY + data.getDescription());
            lore.add("");
            lore.add(ChatColor.GRAY + "Base Value: " + ChatColor.GOLD + FORMAT.format(ins.getBaseValue()));
            lore.add(ChatColor.GRAY + "Default Value: " + ChatColor.GOLD + FORMAT.format(ins.getDefaultValue()));
            lore.add(ChatColor.GRAY + "Total Value: " + ChatColor.GOLD + ChatColor.BOLD + FORMAT.format(ins.getValue()));
            lore.add("");
            lore.add(ChatColor.GRAY + "Attribute Modifiers: " + ChatColor.GOLD + ins.getModifiers().size());
            lore.add(ChatColor.GRAY + "Due to Modifiers: " + ChatColor.GOLD + FORMAT.format(ins.getValue() - ins.getBaseValue()));
            lore.add("");
            lore.add(ChatColor.YELLOW + "\u25b8" + " Left click to explore.");
            lore.add(ChatColor.YELLOW + "\u25b8" + " Right click to set the base value.");
            lore.add(ChatColor.YELLOW + "\u25b8" + " Shift click to reset base value.");
            meta.setLore(lore);
            item.setItemMeta(meta);
            inv.setItem(SLOTS[j++], item);
        }
        ItemBuilder fillAttribute = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE, "&cNo Attribute");
        while (j < SLOTS.length) {
            inv.setItem(SLOTS[j++], (ItemStack)fillAttribute);
        }
        if (this.explored != null) {
            inv.setItem(1, (ItemStack)new ItemBuilder(Material.WRITABLE_BOOK, "&6New Attribute.."));
            inv.setItem(5, (ItemStack)new ItemBuilder(Material.BARRIER, "&6\u21e8 Back"));
            int min = this.page * MOD_SLOTS.length;
            int max = (this.page + 1) * MOD_SLOTS.length;
            int k = min;
            while (k < Math.min(this.modifiers.size(), max)) {
                AttributeModifier modifier = this.modifiers.get(k);
                ItemStack item = new ItemStack(Material.GRAY_DYE);
                ItemMeta meta = item.getItemMeta();
                meta.setDisplayName(ChatColor.GOLD + "Modifier n" + (k + 1));
                ArrayList<String> lore = new ArrayList<String>();
                lore.add("");
                lore.add(ChatColor.GRAY + "Name: " + ChatColor.GOLD + modifier.getName());
                lore.add(ChatColor.GRAY + "Amount: " + ChatColor.GOLD + modifier.getAmount());
                lore.add(ChatColor.GRAY + "Operation: " + ChatColor.GOLD + modifier.getOperation());
                lore.add("");
                lore.add(ChatColor.GRAY + "Slot: " + ChatColor.GOLD + (modifier.getSlot() == null ? "None" : modifier.getSlot().name()));
                lore.add(ChatColor.GRAY + "ID: " + ChatColor.GOLD + modifier.getUniqueId());
                lore.add("");
                lore.add(ChatColor.YELLOW + "\u25b8" + " Right click to remove.");
                meta.setLore(lore);
                item.setItemMeta(meta);
                inv.setItem(MOD_SLOTS[k++ - min], item);
            }
            if (this.modifiers.size() > max) {
                inv.setItem(33, (ItemStack)new ItemBuilder(Material.ARROW, "&6Next Page"));
            }
            if (this.page > 0) {
                inv.setItem(27, (ItemStack)new ItemBuilder(Material.ARROW, "&6Previous Page"));
            }
            ItemBuilder fillModifier = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE, "&cNo Modifier");
            while (k < max) {
                inv.setItem(MOD_SLOTS[k++ - min], (ItemStack)fillModifier);
            }
        }
        return inv;
    }

    public void setExplored(Attribute attribute) {
        this.explored = attribute;
        this.modifiers = this.explored != null ? new ArrayList(this.target.getAttribute(this.explored).getModifiers()) : null;
    }

    private String getName(Attribute attribute) {
        return UtilityMethods.caseOnWords(attribute.name().substring("GENERIC_".length()).toLowerCase().replace("_", " "));
    }

    @Override
    public void whenClicked(InventoryClickEvent event) {
        event.setCancelled(true);
        if (!event.getInventory().equals(event.getClickedInventory())) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (!UtilityMethods.isMetaItem(item)) {
            return;
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GOLD + "Refresh " + ChatColor.DARK_GRAY + "(Click)")) {
            this.setExplored(this.explored);
            this.open();
            return;
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GOLD + "\u21e8" + " Back")) {
            this.setExplored(null);
            this.open();
            return;
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GOLD + "Next Page")) {
            ++this.page;
            this.open();
            return;
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GOLD + "Previous Page")) {
            --this.page;
            this.open();
            return;
        }
        if (item.getItemMeta().getDisplayName().equals(ChatColor.GOLD + "New Attribute..")) {
            new AttributeCreator(this).open();
            return;
        }
        if (item.getItemMeta().getDisplayName().startsWith(ChatColor.GOLD + "Modifier n") && event.getAction() == InventoryAction.PICKUP_HALF) {
            int index = Integer.parseInt(item.getItemMeta().getDisplayName().substring((ChatColor.GOLD + "Modifier n").length())) - 1;
            this.target.getAttribute(this.explored).removeModifier(this.modifiers.get(index));
            this.getPlayer().sendMessage(ChatColor.YELLOW + "> Modifier n" + (index + 1) + " successfully deleted.");
            this.setExplored(this.explored);
            this.open();
            return;
        }
        if (item.getItemMeta().getDisplayName().startsWith(ChatColor.GOLD + ">> ")) {
            Attribute attribute = Attribute.valueOf((String)("GENERIC_" + item.getItemMeta().getDisplayName().substring((ChatColor.GOLD + ">> ").length()).toUpperCase().replace(" ", "_")));
            if (event.getAction() == InventoryAction.PICKUP_ALL) {
                this.setExplored(attribute);
                this.open();
            } else if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                this.target.getAttribute(attribute).setBaseValue(this.target.getAttribute(attribute).getDefaultValue());
                this.getPlayer().sendMessage(ChatColor.YELLOW + "> Base value of " + ChatColor.GOLD + attribute.name() + ChatColor.YELLOW + " successfully reset.");
                this.open();
            } else if (event.getAction() == InventoryAction.PICKUP_HALF) {
                this.getPlayer().closeInventory();
                this.getPlayer().sendMessage(ChatColor.YELLOW + "> Write in the chat the value you want.");
                new ChatInput(this.getPlayer(), output -> {
                    double d;
                    if (output == null) {
                        this.open();
                        return true;
                    }
                    try {
                        d = Double.parseDouble(output);
                    }
                    catch (NumberFormatException exception) {
                        this.getPlayer().sendMessage(ChatColor.RED + "> " + output + " is not a valid number. Type 'cancel' to cancel.");
                        return false;
                    }
                    this.getPlayer().sendMessage(ChatColor.YELLOW + "> Base value set to " + ChatColor.GOLD + FORMAT.format(d) + ChatColor.YELLOW + ".");
                    this.target.getAttribute(attribute).setBaseValue(d);
                    this.open();
                    return true;
                });
            }
        }
    }

    static {
        ATTRIBUTES.put("ARMOR", new AttributeData(Material.IRON_CHESTPLATE, "Armor bonus of an Entity."));
        ATTRIBUTES.put("ARMOR_TOUGHNESS", new AttributeData(Material.GOLDEN_CHESTPLATE, "Armor durability bonus of an Entity."));
        ATTRIBUTES.put("ATTACK_DAMAGE", new AttributeData(Material.IRON_SWORD, "Attack damage of an Entity."));
        ATTRIBUTES.put("ATTACK_SPEED", new AttributeData(Material.LIGHT_GRAY_DYE, "Attack speed of an Entity."));
        ATTRIBUTES.put("KNOCKBACK_RESISTANCE", new AttributeData(Material.TNT_MINECART, "Resistance of an Entity to knockback."));
        ATTRIBUTES.put("LUCK", new AttributeData(Material.GRASS, "Luck bonus of an Entity."));
        ATTRIBUTES.put("MAX_HEALTH", new AttributeData(Material.GOLDEN_APPLE, "Maximum health of an Entity."));
        ATTRIBUTES.put("MOVEMENT_SPEED", new AttributeData(Material.LEATHER_BOOTS, "Movement speed of an Entity."));
    }
}

