/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.listener.option;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.event.IndicatorDisplayEvent;
import io.lumine.mythic.lib.hologram.Hologram;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public abstract class GameIndicators
implements Listener {
    private final String format;
    private final DecimalFormat decFormat;
    private final double radialVelocity;
    private final double gravity;
    private final double initialUpwardVelocity;
    private final double entityHeightPercentage;
    private final double yOffset;
    protected static final Random random = new Random();
    private static final int HOLOGRAM_LIFE_SPAN = 7;

    public GameIndicators(ConfigurationSection config) {
        this.decFormat = MythicLib.plugin.getMMOConfig().newDecimalFormat(config.getString("decimal-format"));
        this.format = config.getString("format");
        this.radialVelocity = config.getDouble("radial-velocity", 1.0);
        this.gravity = config.getDouble("gravity", 1.0);
        this.initialUpwardVelocity = config.getDouble("initial-upward-velocity", 1.0);
        this.entityHeightPercentage = config.getDouble("entity-height-percent", 0.75);
        this.yOffset = config.getDouble("y-offset", 0.1);
    }

    public String formatNumber(double d) {
        return this.decFormat.format(d);
    }

    public String getRaw() {
        return this.format;
    }

    public void displayIndicator(Entity entity, String message, @NotNull Vector dir2, IndicatorDisplayEvent.IndicatorType type) {
        IndicatorDisplayEvent called = new IndicatorDisplayEvent(entity, message, type);
        Bukkit.getPluginManager().callEvent((Event)called);
        if (called.isCancelled()) {
            return;
        }
        Location loc = entity.getLocation().add((random.nextDouble() - 0.5) * 1.2, this.yOffset + entity.getHeight() * this.entityHeightPercentage, (random.nextDouble() - 0.5) * 1.2);
        this.displayIndicator(loc, called.getMessage(), dir2);
    }

    private void displayIndicator(final Location loc, String message, final @NotNull Vector dir2) {
        final Hologram holo = Hologram.create(loc, MythicLib.plugin.parseColors(Collections.singletonList(message)));
        new BukkitRunnable(){
            double v;
            int i;
            private final double acc;
            private final double dt = 0.15;
            {
                this.v = 6.0 * GameIndicators.this.initialUpwardVelocity;
                this.i = 0;
                this.acc = -10.0 * GameIndicators.this.gravity;
                this.dt = 0.15;
            }

            public void run() {
                if (this.i == 0) {
                    dir2.multiply(2.0 * GameIndicators.this.radialVelocity);
                }
                if (this.i++ >= 7) {
                    holo.despawn();
                    this.cancel();
                    return;
                }
                this.v += this.acc * 0.15;
                loc.add(dir2.getX() * 0.15, this.v * 0.15, dir2.getZ() * 0.15);
                holo.updateLocation(loc);
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 3L);
    }
}

