/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.mechanic.buff;

import io.lumine.mythic.lib.script.mechanic.MechanicMetadata;
import io.lumine.mythic.lib.script.mechanic.type.TargetMechanic;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.util.DoubleFormula;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.FoodLevelChangeEvent;

@MechanicMetadata
public class FeedMechanic
extends TargetMechanic {
    private final DoubleFormula amount;

    public FeedMechanic(ConfigObject config) {
        super(config);
        config.validateKeys("amount");
        this.amount = new DoubleFormula(config.getString("amount"));
    }

    @Override
    public void cast(SkillMetadata meta, Entity target) {
        Validate.isTrue((boolean)(target instanceof Player), (String)"Can only feed a player");
        Player player = (Player)target;
        FoodLevelChangeEvent called = new FoodLevelChangeEvent((HumanEntity)player, (int)this.amount.evaluate(meta));
        Bukkit.getPluginManager().callEvent((Event)called);
        if (called.isCancelled()) {
            return;
        }
        player.setFoodLevel(Math.min(20, Math.max(0, called.getFoodLevel())));
    }
}

