/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.mechanic.shaped;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.comp.interaction.InteractionType;
import io.lumine.mythic.lib.script.Script;
import io.lumine.mythic.lib.script.mechanic.type.DirectionMechanic;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.util.DoubleFormula;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import java.util.function.Predicate;
import org.apache.commons.lang.Validate;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class ProjectileMechanic
extends DirectionMechanic {
    private final DoubleFormula speed;
    private final DoubleFormula size;
    private final DoubleFormula lifeSpan;
    private final DoubleFormula step;
    private final Script onHitBlock;
    private final Script onHitEntity;
    private final Script onTick;
    private final boolean ignorePassable;
    private final boolean stopOnBlock;
    private final boolean offense;
    private final int hitLimit;
    private static final double DEFAULT_LIFE_SPAN = 60.0;
    private static final double DEFAULT_SIZE = 0.2;
    private static final double DEFAULT_STEP = 0.2;

    public ProjectileMechanic(ConfigObject config) {
        super(config);
        this.onTick = config.contains("tick") ? MythicLib.plugin.getSkills().getScriptOrThrow(config.getString("tick")) : null;
        this.onHitEntity = config.contains("hit_entity") ? MythicLib.plugin.getSkills().getScriptOrThrow(config.getString("hit_entity")) : null;
        this.onHitBlock = config.contains("hit_block") ? MythicLib.plugin.getSkills().getScriptOrThrow(config.getString("hit_block")) : null;
        this.ignorePassable = config.getBoolean("ignore_passable", false);
        this.offense = config.getBoolean("offense", true);
        this.hitLimit = config.getInt("hits", 1);
        this.stopOnBlock = config.getBoolean("stop_on_block", true);
        this.speed = config.contains("speed") ? new DoubleFormula(config.getString("speed")) : new DoubleFormula(1.0);
        this.size = config.contains("size") ? new DoubleFormula(config.getString("size")) : new DoubleFormula(0.2);
        this.step = config.contains("step") ? new DoubleFormula(config.getString("step")) : new DoubleFormula(0.2);
        this.lifeSpan = config.contains("life_span") ? new DoubleFormula(config.getString("life_span")) : new DoubleFormula(60.0);
    }

    @Override
    public void cast(final SkillMetadata meta, final Location source, final Vector dir2) {
        Validate.isTrue((dir2.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction cannot be zero");
        new BukkitRunnable(){
            final Vector dr;
            final double dl;
            final double projectileSize;
            final double projLifeSpan;
            final double smallest_d;
            Location current;
            int counter;
            int entityHits;
            {
                this.dr = dir2.normalize().clone().multiply(0.5 * ProjectileMechanic.this.speed.evaluate(meta));
                this.dl = this.dr.length();
                this.projectileSize = ProjectileMechanic.this.size.evaluate(meta);
                this.projLifeSpan = ProjectileMechanic.this.lifeSpan.evaluate(meta);
                this.smallest_d = ProjectileMechanic.this.step.evaluate(meta);
                this.current = source.clone();
                this.counter = 0;
                this.entityHits = 0;
            }

            public void run() {
                RayTraceResult result;
                int n = this.counter++;
                if ((double)n >= this.projLifeSpan) {
                    this.cancel();
                }
                this.current.add(this.dr);
                Predicate<Entity> filter = entity -> MythicLib.plugin.getEntities().canInteract(meta.getCaster().getPlayer(), (Entity)entity, ProjectileMechanic.this.offense ? InteractionType.OFFENSE_SKILL : InteractionType.SUPPORT_SKILL);
                RayTraceResult rayTraceResult = result = ProjectileMechanic.this.onHitBlock != null ? this.current.getWorld().rayTrace(this.current, dir2, this.dl, FluidCollisionMode.NEVER, ProjectileMechanic.this.ignorePassable, this.projectileSize, filter) : this.current.getWorld().rayTraceEntities(this.current, dir2, this.dl, this.projectileSize, filter);
                if (ProjectileMechanic.this.onTick != null) {
                    for (double j = 0.0; j < this.dl; j += this.smallest_d) {
                        Location intermediate = this.current.clone().add(dir2.clone().multiply(j));
                        ProjectileMechanic.this.onTick.cast(meta.clone(source, intermediate, null, null));
                    }
                }
                if (result == null) {
                    return;
                }
                if (ProjectileMechanic.this.onHitBlock != null && result.getHitBlock() != null) {
                    ProjectileMechanic.this.onHitBlock.cast(meta.clone(source, result.getHitPosition().toLocation(this.current.getWorld()), null, null));
                    if (ProjectileMechanic.this.stopOnBlock) {
                        this.cancel();
                    }
                }
                if (ProjectileMechanic.this.onHitEntity != null && result.getHitEntity() != null) {
                    ProjectileMechanic.this.onHitEntity.cast(meta.clone(source, result.getHitPosition().toLocation(this.current.getWorld()), result.getHitEntity(), null));
                    ++this.entityHits;
                    if (this.entityHits >= ProjectileMechanic.this.hitLimit) {
                        this.cancel();
                    }
                }
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
    }
}

