/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.variable;

import io.lumine.mythic.lib.script.variable.VariableContainer;
import io.lumine.mythic.lib.script.variable.VariableMetadata;
import io.lumine.mythic.lib.script.variable.VariableRegistry;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;

public abstract class Variable<T>
implements VariableContainer {
    private final String name;
    private T stored;

    public Variable(String name, T stored) {
        this.name = name;
        this.stored = stored;
        Validate.isTrue((boolean)this.getClass().isAnnotationPresent(VariableMetadata.class), (String)"Variable type with no VariableMetadata annotation");
    }

    public String getName() {
        return this.name;
    }

    public T getStored() {
        return this.stored;
    }

    public void setStored(T t) {
        this.stored = t;
    }

    public abstract VariableRegistry getVariableRegistry();

    @Override
    @Nullable
    public Variable getVariable(String name) {
        return this.getVariableRegistry().accessVariable(this, name);
    }

    public String toString() {
        return this.stored == null ? "None" : this.stored.toString();
    }
}

