/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.variable.def;

import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.script.variable.SimpleVariableRegistry;
import io.lumine.mythic.lib.script.variable.Variable;
import io.lumine.mythic.lib.script.variable.VariableMetadata;
import io.lumine.mythic.lib.script.variable.VariableRegistry;
import io.lumine.mythic.lib.script.variable.def.AttributesVariable;
import io.lumine.mythic.lib.script.variable.def.CooldownsVariable;
import io.lumine.mythic.lib.script.variable.def.DoubleVariable;
import io.lumine.mythic.lib.script.variable.def.IntegerVariable;
import io.lumine.mythic.lib.script.variable.def.PositionVariable;
import io.lumine.mythic.lib.script.variable.def.StatsVariable;
import io.lumine.mythic.lib.script.variable.def.StringVariable;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attributable;
import org.bukkit.entity.Player;

@VariableMetadata(name="player")
public class PlayerVariable
extends Variable<Player> {
    public static final SimpleVariableRegistry<PlayerVariable> VARIABLE_REGISTRY = new SimpleVariableRegistry();

    public PlayerVariable(String name, Player player) {
        super(name, player);
    }

    @Override
    public VariableRegistry getVariableRegistry() {
        return VARIABLE_REGISTRY;
    }

    @Override
    public String toString() {
        return this.getStored() == null ? "None" : ((Player)this.getStored()).getName();
    }

    static {
        VARIABLE_REGISTRY.registerVariable("id", var -> new IntegerVariable("temp", ((Player)var.getStored()).getEntityId()));
        VARIABLE_REGISTRY.registerVariable("uuid", var -> new StringVariable("temp", ((Player)var.getStored()).getUniqueId().toString()));
        VARIABLE_REGISTRY.registerVariable("type", var -> new StringVariable("temp", ((Player)var.getStored()).getType().name()));
        VARIABLE_REGISTRY.registerVariable("location", var -> new PositionVariable("temp", ((Player)var.getStored()).getLocation()));
        VARIABLE_REGISTRY.registerVariable("health", var -> new DoubleVariable("temp", ((Player)var.getStored()).getHealth()));
        VARIABLE_REGISTRY.registerVariable("looking", var -> new PositionVariable("temp", ((Player)var.getStored()).getWorld(), ((Player)var.getStored()).getEyeLocation().getDirection()));
        VARIABLE_REGISTRY.registerVariable("velocity", var -> new PositionVariable("temp", ((Player)var.getStored()).getWorld(), ((Player)var.getStored()).getVelocity()));
        VARIABLE_REGISTRY.registerVariable("height", var -> new DoubleVariable("temp", ((Player)var.getStored()).getHeight()));
        VARIABLE_REGISTRY.registerVariable("attribute", var -> new AttributesVariable("temp", (Attributable)var.getStored()));
        VARIABLE_REGISTRY.registerVariable("fire_ticks", var -> new IntegerVariable("temp", ((Player)var.getStored()).getFireTicks()));
        VARIABLE_REGISTRY.registerVariable("stat", var -> new StatsVariable("temp", MMOPlayerData.get((OfflinePlayer)var.getStored()).getStatMap()));
        VARIABLE_REGISTRY.registerVariable("cooldown", var -> new CooldownsVariable("temp", MMOPlayerData.get((OfflinePlayer)var.getStored()).getCooldownMap()));
        VARIABLE_REGISTRY.registerVariable("name", var -> new StringVariable("temp", ((Player)var.getStored()).getName()));
    }
}

