/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.event.skill.PlayerCastSkillEvent;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.api.stat.modifier.StatModifier;
import io.lumine.mythic.lib.api.util.TemporaryListener;
import io.lumine.mythic.lib.player.modifier.ModifierType;
import io.lumine.mythic.lib.skill.Skill;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.result.SkillResult;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class CastingDelayHandler
extends TemporaryListener {
    private final SkillMetadata metadata;
    private final double slowness;
    private final int delayTicks;
    @NotNull
    private final BukkitRunnable runnable;
    @Nullable
    private final BossBar bossbar;
    private static final String MOVEMENT_SPEED_MODIFIER_KEY = "mythiclibSkillCasting";

    public CastingDelayHandler(final SkillMetadata metadata, final SkillResult result) {
        super(PlayerMoveEvent.getHandlerList(), PlayerCastSkillEvent.getHandlerList());
        this.metadata = metadata;
        this.delayTicks = (int)(metadata.getModifier("delay") * 20.0);
        this.runnable = new BukkitRunnable(){
            private int counter;
            {
                this.counter = CastingDelayHandler.this.delayTicks;
            }

            public void run() {
                if (CastingDelayHandler.this.hasBossbar()) {
                    CastingDelayHandler.this.bossbar.setProgress((double)(CastingDelayHandler.this.delayTicks - this.counter) / (double)CastingDelayHandler.this.delayTicks);
                }
                --this.counter;
                if (this.counter <= 0) {
                    if (CastingDelayHandler.this.hasBossbar()) {
                        CastingDelayHandler.this.bossbar.removeAll();
                    }
                    this.cancel();
                    CastingDelayHandler.this.close();
                    metadata.getCast().castInstantly(metadata, result);
                }
            }
        };
        this.runnable.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
        this.castIfNotNull(MythicLib.plugin.getMMOConfig().skillCastScript);
        this.slowness = MythicLib.plugin.getMMOConfig().castingDelaySlowness;
        if (this.slowness > 0.0) {
            new StatModifier(MOVEMENT_SPEED_MODIFIER_KEY, "MOVEMENT_SPEED", -this.slowness, ModifierType.RELATIVE).register(this.getCaster());
        }
        this.bossbar = MythicLib.plugin.getMMOConfig().enableCastingDelayBossbar ? this.handleBossbar() : null;
    }

    public MMOPlayerData getCaster() {
        return this.metadata.getCaster().getData();
    }

    public boolean hasBossbar() {
        return this.bossbar != null;
    }

    private void castIfNotNull(@Nullable Skill skill) {
        if (skill != null) {
            skill.cast(new SkillMetadata(skill, this.getCaster()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockY() == event.getTo().getBlockY() && event.getFrom().getBlockZ() == event.getTo().getBlockZ()) {
            return;
        }
        if (!event.getPlayer().equals(this.getCaster().getPlayer())) {
            return;
        }
        if (MythicLib.plugin.getMMOConfig().castingDelayCancelOnMove) {
            event.setCancelled(true);
            this.castIfNotNull(MythicLib.plugin.getMMOConfig().skillCancelScript);
            this.close();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCast(PlayerCastSkillEvent event) {
        if (event.getPlayer().equals(this.getCaster().getPlayer())) {
            event.setCancelled(true);
        }
    }

    @NotNull
    private BossBar handleBossbar() {
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)MythicLib.plugin, "mythiclib_casting_" + this.getCaster().getUniqueId());
        KeyedBossBar bossbar = Bukkit.createBossBar((NamespacedKey)namespacedKey, (String)MythicLib.plugin.getMMOConfig().castingDelayBossbarFormat, (BarColor)BarColor.WHITE, (BarStyle)BarStyle.SEGMENTED_20, (BarFlag[])new BarFlag[0]);
        bossbar.addPlayer(this.getCaster().getPlayer());
        return bossbar;
    }

    @Override
    public void whenClosed() {
        if (!this.runnable.isCancelled()) {
            this.runnable.cancel();
        }
        if (this.slowness > 0.0) {
            this.getCaster().getStatMap().getInstance("MOVEMENT_SPEED").remove(MOVEMENT_SPEED_MODIFIER_KEY);
        }
    }
}

