/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.damage.AttackMetadata;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.player.PlayerMetadata;
import io.lumine.mythic.lib.script.variable.Variable;
import io.lumine.mythic.lib.script.variable.VariableList;
import io.lumine.mythic.lib.script.variable.VariableScope;
import io.lumine.mythic.lib.script.variable.def.AttackMetadataVariable;
import io.lumine.mythic.lib.script.variable.def.DoubleVariable;
import io.lumine.mythic.lib.script.variable.def.EntityVariable;
import io.lumine.mythic.lib.script.variable.def.PlayerVariable;
import io.lumine.mythic.lib.script.variable.def.PositionVariable;
import io.lumine.mythic.lib.script.variable.def.StatsVariable;
import io.lumine.mythic.lib.skill.Skill;
import io.lumine.mythic.lib.util.EntityLocationType;
import io.lumine.mythic.lib.util.SkillOrientation;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SkillMetadata {
    private final Skill cast;
    private final PlayerMetadata caster;
    private final VariableList vars;
    @NotNull
    private final Location source;
    @Nullable
    private final Location targetLocation;
    @Nullable
    private final Entity targetEntity;
    @Nullable
    public final SkillOrientation orientation;
    public static final VariableList SERVER_VARIABLE_LIST = new VariableList(VariableScope.SERVER);
    private static final Pattern INTERNAL_PLACEHOLDER_PATTERN = Pattern.compile("<.*?>");

    public SkillMetadata(Skill cast, @NotNull MMOPlayerData caster) {
        this(cast, caster.getStatMap().cache(EquipmentSlot.MAIN_HAND), new VariableList(VariableScope.SKILL), null, caster.getPlayer().getLocation(), null, null, null);
    }

    @Deprecated
    public SkillMetadata(Skill cast, @NotNull AttackMetadata attackMeta, @NotNull Location source, @Nullable Location targetLocation, @Nullable Entity targetEntity) {
        this(cast, (PlayerMetadata)attackMeta.getAttacker(), new VariableList(VariableScope.SKILL), attackMeta, source, targetLocation, targetEntity, null);
    }

    @Deprecated
    public SkillMetadata(Skill cast, @NotNull PlayerMetadata caster, @NotNull VariableList vars, @Nullable AttackMetadata attackMeta, @NotNull Location source, @Nullable Location targetLocation, @Nullable Entity targetEntity, @Nullable SkillOrientation orientation) {
        this(cast, caster, vars, source, targetLocation, targetEntity, orientation);
    }

    public SkillMetadata(Skill cast, @NotNull PlayerMetadata caster, @NotNull VariableList vars, @NotNull Location source, @Nullable Location targetLocation, @Nullable Entity targetEntity, @Nullable SkillOrientation orientation) {
        this.cast = cast;
        this.caster = caster;
        this.vars = vars;
        this.source = source;
        this.targetLocation = targetLocation;
        this.targetEntity = targetEntity;
        this.orientation = orientation;
    }

    public Skill getCast() {
        return this.cast;
    }

    public VariableList getVariableList() {
        return this.vars;
    }

    public PlayerMetadata getCaster() {
        return this.caster;
    }

    public Location getSourceLocation() {
        return this.source.clone();
    }

    @Deprecated
    public boolean hasAttackBound() {
        return this.targetEntity != null && MythicLib.plugin.getDamage().getRegisteredAttackMetadata(this.targetEntity) != null;
    }

    public double getModifier(String path) {
        return this.cast.getModifier(path);
    }

    @NotNull
    public Entity getTargetEntity() {
        return Objects.requireNonNull(this.targetEntity, "Skill has no target entity");
    }

    @Nullable
    public Entity getTargetEntityOrNull() {
        return this.targetEntity;
    }

    public boolean hasTargetEntity() {
        return this.targetEntity != null;
    }

    @NotNull
    public Location getTargetLocation() {
        return Objects.requireNonNull(this.targetLocation, "Skill has no target location").clone();
    }

    @Nullable
    public Location getTargetLocationOrNull() {
        return this.targetLocation == null ? null : this.targetLocation.clone();
    }

    public boolean hasTargetLocation() {
        return this.targetLocation != null;
    }

    @NotNull
    public SkillOrientation getOrientation() {
        return Objects.requireNonNull(this.orientation, "Skill has no orientation");
    }

    @Nullable
    public SkillOrientation getOrientationOrNull() {
        return this.orientation;
    }

    public boolean hasOrientation() {
        return this.orientation != null;
    }

    @NotNull
    public Location getSkillLocation(boolean sourceLocation) {
        return sourceLocation ? this.source.clone() : (this.targetLocation != null ? this.targetLocation.clone() : (this.targetEntity != null ? EntityLocationType.BODY.getLocation(this.targetEntity) : this.source.clone()));
    }

    @NotNull
    public Entity getSkillEntity(boolean caster) {
        return caster || this.targetEntity == null ? this.getCaster().getPlayer() : this.targetEntity;
    }

    @NotNull
    public AttackMetadata getAttack() {
        return Objects.requireNonNull(MythicLib.plugin.getDamage().getRegisteredAttackMetadata(this.getTargetEntity()), "Skill has no attack bound");
    }

    @NotNull
    public SkillOrientation getSkillOrientation() {
        return this.orientation != null ? this.orientation : new SkillOrientation(Objects.requireNonNull(this.targetLocation, "Skill has no orientation"), this.targetLocation.subtract(this.source).toVector());
    }

    @NotNull
    public SkillMetadata clone(Location source, Location targetLocation, Entity targetEntity, SkillOrientation orientation) {
        return new SkillMetadata(this.cast, this.caster, this.vars, source, targetLocation, targetEntity, orientation);
    }

    public Variable getReference(String name) {
        Variable var;
        String[] args = name.split("\\.");
        int i = 1;
        switch (args[0]) {
            case "modifier": {
                Validate.isTrue((args.length > 1 ? 1 : 0) != 0, (String)"Please specify a modifier name");
                var = new DoubleVariable("temp", this.getModifier(args[i++]));
                break;
            }
            case "source": {
                var = new PositionVariable("temp", this.source);
                break;
            }
            case "targetLocation": {
                var = new PositionVariable("temp", this.getTargetLocation());
                break;
            }
            case "caster": {
                var = new PlayerVariable("temp", this.getCaster().getPlayer());
                break;
            }
            case "attack": {
                var = new AttackMetadataVariable("temp", this.getAttack());
                break;
            }
            case "stat": {
                var = new StatsVariable("temp", this.caster);
                break;
            }
            case "target": {
                Validate.notNull((Object)this.targetEntity, (String)"Skill has no target");
                var = this.targetEntity instanceof Player ? new PlayerVariable("temp", (Player)this.targetEntity) : new EntityVariable("temp", this.targetEntity);
                break;
            }
            case "var": {
                Validate.isTrue((args.length > 1 ? 1 : 0) != 0, (String)"Custom variable name not specified");
                var = this.getCustomVariable(args[i++]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not match variable type to '" + args[0] + "', did you mean 'var." + args[0] + "'?");
            }
        }
        while (i < args.length) {
            var = var.getVariable(args[i]);
            ++i;
        }
        return var;
    }

    @NotNull
    public Variable getCustomVariable(String name) {
        Variable var = this.vars.getVariable(name);
        if (var != null) {
            return var;
        }
        var = this.getCaster().getData().getVariableList().getVariable(name);
        if (var != null) {
            return var;
        }
        return Objects.requireNonNull(SERVER_VARIABLE_LIST.getVariable(name), "Could not find custom variable with name '" + name + "'");
    }

    public String parseString(String str) {
        str = MythicLib.plugin.getPlaceholderParser().parse((OfflinePlayer)this.getCaster().getPlayer(), str);
        Matcher match = INTERNAL_PLACEHOLDER_PATTERN.matcher(str);
        while (match.find()) {
            String placeholder = str.substring(match.start() + 1, match.end() - 1);
            str = str.replace("<" + placeholder + ">", this.getReference(placeholder).toString());
            match = INTERNAL_PLACEHOLDER_PATTERN.matcher(str);
        }
        return str;
    }

    @Deprecated
    @NotNull
    public AttackMetadata attack(@NotNull LivingEntity target, double damage, DamageType ... types) {
        return this.caster.attack(target, damage, types);
    }
}

