/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.api.skills.SkillShot;
import com.sucy.skill.api.skills.TargetSkill;
import com.sucy.skill.log.Logger;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.SkillAPISkillResult;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.LivingEntity;

public class SkillAPISkillHandler
extends SkillHandler<SkillAPISkillResult> {
    private final Skill skill;

    public SkillAPISkillHandler(ConfigurationSection config) {
        super(config.getString("skillapi-skill-id"));
        String skillName = config.getString("skillapi-skill-id");
        this.skill = Objects.requireNonNull(SkillAPI.getSkill((String)skillName), "Could not find SkillAPI skill with name '" + skillName + "'");
        this.registerModifiers("level");
    }

    public Skill getSkill() {
        return this.skill;
    }

    @Override
    public SkillAPISkillResult getResult(SkillMetadata meta) {
        return new SkillAPISkillResult(meta, this.skill);
    }

    @Override
    public void whenCast(SkillAPISkillResult result, SkillMetadata skillMeta) {
        if (this.skill instanceof SkillShot) {
            try {
                ((SkillShot)this.skill).cast((LivingEntity)skillMeta.getCaster().getPlayer(), result.getLevel());
            }
            catch (Exception exception) {
                Logger.bug((String)("Failed to cast skill - " + this.skill.getName() + ": Internal skill error"));
                exception.printStackTrace();
            }
        } else if (this.skill instanceof TargetSkill) {
            try {
                boolean isAlly = !SkillAPI.getSettings().canAttack((LivingEntity)skillMeta.getCaster().getPlayer(), result.getTarget());
                ((TargetSkill)this.skill).cast((LivingEntity)skillMeta.getCaster().getPlayer(), result.getTarget(), result.getLevel(), isAlly);
            }
            catch (Exception exception) {
                Logger.bug((String)("Failed to cast skill - " + this.skill.getName() + ": Internal skill error"));
                exception.printStackTrace();
            }
        }
    }
}

