/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler;

import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.result.SkillResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public abstract class SkillHandler<T extends SkillResult> {
    private final String id;
    private final Set<String> modifiers = new HashSet<String>();
    private final boolean triggerable;
    protected static final Random random = new Random();

    public SkillHandler() {
        this(true);
    }

    public SkillHandler(boolean triggerable) {
        this.id = this.formatId(this.getClass().getSimpleName());
        this.triggerable = triggerable;
        this.registerModifiers("cooldown", "mana", "stamina", "timer", "delay");
    }

    public SkillHandler(@NotNull String id) {
        this.id = this.formatId(id);
        this.triggerable = true;
        this.registerModifiers("cooldown", "mana", "stamina", "timer", "delay");
    }

    public SkillHandler(@NotNull ConfigurationSection config, @NotNull String id) {
        this.id = this.formatId(id);
        this.triggerable = true;
        if (config.contains("modifiers")) {
            this.registerModifiers(config.getStringList("modifiers"));
        }
        this.registerModifiers("cooldown", "mana", "stamina", "timer", "delay");
    }

    private String formatId(String str) {
        return str.toUpperCase().replace("-", "_").replace(" ", "_").replaceAll("[^A-Z_]", "");
    }

    public String getId() {
        return this.id;
    }

    public String getLowerCaseId() {
        return this.id.toLowerCase().replace("_", "-");
    }

    public void registerModifiers(String ... mods) {
        this.registerModifiers(Arrays.asList(mods));
    }

    public void registerModifiers(Collection<String> mods) {
        this.modifiers.addAll(mods);
    }

    public boolean isTriggerable() {
        return this.triggerable;
    }

    public Set<String> getModifiers() {
        return this.modifiers;
    }

    @NotNull
    public abstract T getResult(SkillMetadata var1);

    public abstract void whenCast(T var1, SkillMetadata var2);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkillHandler that = (SkillHandler)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

