/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.simple;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.util.TemporaryListener;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.SimpleSkillResult;
import io.lumine.mythic.lib.version.VersionSound;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Bunny_Mode
extends SkillHandler<SimpleSkillResult> {
    public Bunny_Mode() {
        this.registerModifiers("duration", "jump-force", "speed");
    }

    @Override
    public SimpleSkillResult getResult(SkillMetadata meta) {
        return new SimpleSkillResult();
    }

    @Override
    public void whenCast(SimpleSkillResult result, SkillMetadata skillMeta) {
        final double duration = skillMeta.getModifier("duration") * 20.0;
        final double y = skillMeta.getModifier("jump-force");
        final double xz = skillMeta.getModifier("speed");
        final Player caster = skillMeta.getCaster().getPlayer();
        new BukkitRunnable(){
            final BunnyModeEffect handler;
            int j;
            {
                this.handler = new BunnyModeEffect(caster, duration);
                this.j = 0;
            }

            public void run() {
                int n = this.j++;
                if ((double)n > duration) {
                    this.handler.close(60L);
                    this.cancel();
                    return;
                }
                if (caster.getLocation().add(0.0, -0.5, 0.0).getBlock().getType().isSolid()) {
                    caster.setVelocity(caster.getEyeLocation().getDirection().setY(0).normalize().multiply(0.8 * xz).setY(0.5 * y / xz));
                    caster.getWorld().playSound(caster.getLocation(), VersionSound.ENTITY_ENDER_DRAGON_FLAP.toSound(), 2.0f, 1.0f);
                    for (double a = 0.0; a < Math.PI * 2; a += 0.2617993877991494) {
                        caster.getWorld().spawnParticle(Particle.CLOUD, caster.getLocation(), 0, Math.cos(a), 0.0, Math.sin(a), 0.2);
                    }
                }
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
    }

    public class BunnyModeEffect
    extends TemporaryListener {
        private final Player player;

        public BunnyModeEffect(Player player, double duration) {
            super(EntityDamageEvent.getHandlerList());
            this.player = player;
            this.close((long)(duration * 20.0));
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void a(EntityDamageEvent event) {
            if (event.getEntity().equals(this.player) && event.getCause() == EntityDamageEvent.DamageCause.FALL) {
                event.setCancelled(true);
            }
        }

        @Override
        public void whenClosed() {
        }
    }
}

