/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.target;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.TargetSkillResult;
import io.lumine.mythic.lib.version.VersionSound;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Shock
extends SkillHandler<TargetSkillResult> {
    public Shock() {
        this.registerModifiers("duration");
    }

    @Override
    public TargetSkillResult getResult(SkillMetadata meta) {
        return new TargetSkillResult(meta);
    }

    @Override
    public void whenCast(TargetSkillResult result, SkillMetadata skillMeta) {
        final LivingEntity target = result.getTarget();
        final Player caster = skillMeta.getCaster().getPlayer();
        final double duration = skillMeta.getModifier("duration");
        target.getWorld().playSound(target.getLocation(), VersionSound.ENTITY_ZOMBIE_PIGMAN_ANGRY.toSound(), 1.0f, 2.0f);
        new BukkitRunnable(){
            final Location loc;
            final double rads;
            double ti;
            {
                this.loc = target.getLocation();
                this.ti = this.rads = Math.toRadians(caster.getEyeLocation().getYaw() - 90.0f);
            }

            public void run() {
                for (int j = 0; j < 3; ++j) {
                    this.ti += 0.20943951023931953;
                    target.getWorld().spawnParticle(Particle.SMOKE_LARGE, this.loc.clone().add(Math.cos(this.ti), 1.0, Math.sin(this.ti)), 0);
                }
                if (this.ti >= Math.PI * 2 + this.rads) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
        new BukkitRunnable(){
            int ti;

            public void run() {
                double d = this.ti++;
                double d2 = duration > 300.0 ? 300.0 : duration * 10.0;
                if (d > d2 || target.isDead()) {
                    this.cancel();
                } else {
                    target.playEffect(EntityEffect.HURT);
                }
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 2L);
    }
}

