/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.target;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.TargetSkillResult;
import io.lumine.mythic.lib.util.ParabolicProjectile;
import io.lumine.mythic.lib.util.SmallParticleEffect;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Weaken
extends SkillHandler<TargetSkillResult> {
    public Weaken() {
        this.registerModifiers("ratio", "duration");
    }

    @Override
    public TargetSkillResult getResult(SkillMetadata meta) {
        return new TargetSkillResult(meta);
    }

    @Override
    public void whenCast(TargetSkillResult result, SkillMetadata skillMeta) {
        LivingEntity target = result.getTarget();
        Player caster = skillMeta.getCaster().getPlayer();
        new ParabolicProjectile(caster.getPlayer().getLocation().add(0.0, 1.0, 0.0), target.getLocation().add(0.0, target.getHeight() / 2.0, 0.0), this.randomVector(caster.getPlayer()), () -> {
            if (!target.isDead()) {
                new Weakened((Entity)target, skillMeta.getModifier("ratio"), skillMeta.getModifier("duration"));
            }
        }, 2, Particle.SPELL_WITCH);
    }

    private Vector randomVector(Player player) {
        double a = Math.toRadians(player.getEyeLocation().getYaw() + 90.0f);
        return new Vector(Math.cos(a += (double)(random.nextBoolean() ? 1 : -1) * (random.nextDouble() + 0.5) * Math.PI / 6.0), 0.8, Math.sin(a)).normalize().multiply(0.4);
    }

    public static class Weakened
    implements Listener {
        private final Entity entity;
        private final double c;

        public Weakened(Entity entity, double ratio, double duration) {
            this.entity = entity;
            this.c = 1.0 + ratio / 100.0;
            new SmallParticleEffect(entity, Particle.SPELL_WITCH);
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)MythicLib.plugin);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicLib.plugin, () -> EntityDamageByEntityEvent.getHandlerList().unregister((Listener)this), (long)((int)duration * 20));
        }

        @EventHandler
        public void a(EntityDamageByEntityEvent event) {
            if (event.getEntity().equals(this.entity)) {
                event.getEntity().getWorld().spawnParticle(Particle.SPELL_WITCH, this.entity.getLocation().add(0.0, this.entity.getHeight() / 2.0, 0.0), 16, 0.5, 0.5, 0.5, 0.0);
                event.setDamage(event.getDamage() * this.c);
            }
        }
    }
}

