/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.vector;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.VectorSkillResult;
import io.lumine.mythic.lib.version.VersionSound;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Fire_Meteor
extends SkillHandler<VectorSkillResult> {
    public Fire_Meteor() {
        this.registerModifiers("damage", "knockback", "radius");
    }

    @Override
    public VectorSkillResult getResult(SkillMetadata meta) {
        return new VectorSkillResult(meta);
    }

    @Override
    public void whenCast(final VectorSkillResult result, final SkillMetadata skillMeta) {
        final Player caster = skillMeta.getCaster().getPlayer();
        caster.getWorld().playSound(caster.getLocation(), VersionSound.ENTITY_ENDERMAN_TELEPORT.toSound(), 3.0f, 1.0f);
        new BukkitRunnable(){
            final Location loc;
            final Vector vec;
            double ti;
            {
                this.loc = caster.getLocation().clone().add(0.0, 10.0, 0.0);
                this.vec = result.getTarget().multiply(1.3).setY(-1).normalize();
                this.ti = 0.0;
            }

            public void run() {
                this.ti += 1.0;
                if (this.ti > 40.0) {
                    this.cancel();
                }
                this.loc.add(this.vec);
                this.loc.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, this.loc, 0);
                this.loc.getWorld().spawnParticle(Particle.FLAME, this.loc, 4, 0.2, 0.2, 0.2, 0.0);
                if (this.loc.getBlock().getRelative(BlockFace.DOWN).getType().isSolid() || this.loc.getBlock().getType().isSolid()) {
                    this.loc.getWorld().playSound(this.loc, Sound.ENTITY_GENERIC_EXPLODE, 3.0f, 0.6f);
                    this.loc.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, this.loc, 10, 2.0, 2.0, 2.0, 0.0);
                    this.loc.getWorld().spawnParticle(Particle.EXPLOSION_NORMAL, this.loc, 32, 0.0, 0.0, 0.0, 0.3);
                    this.loc.getWorld().spawnParticle(Particle.FLAME, this.loc, 32, 0.0, 0.0, 0.0, 0.3);
                    double damage = skillMeta.getModifier("damage");
                    double knockback = skillMeta.getModifier("knockback");
                    double radius = skillMeta.getModifier("radius");
                    for (Entity entity : UtilityMethods.getNearbyChunkEntities(this.loc)) {
                        if (!UtilityMethods.canTarget(caster, entity) || !(entity.getLocation().distanceSquared(this.loc) < radius * radius)) continue;
                        skillMeta.getCaster().attack((LivingEntity)entity, damage, DamageType.SKILL, DamageType.MAGIC, DamageType.PROJECTILE);
                        entity.setVelocity(entity.getLocation().toVector().subtract(this.loc.toVector()).multiply(0.1 * knockback).setY(0.4 * knockback));
                    }
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
    }
}

