/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.sql;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.sql.hikari.HikariConfig;
import io.lumine.mythic.lib.sql.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class MMODataSource {
    protected final JavaPlugin plugin;
    protected final HikariConfig config = new HikariConfig();
    private HikariDataSource dataSource;
    private boolean enabled;

    protected MMODataSource(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void setup(FileConfiguration fileConfig) {
        if (fileConfig.isConfigurationSection("mysql")) {
            ConfigurationSection cfg = fileConfig.getConfigurationSection("mysql");
            this.enabled = cfg.getBoolean("enabled");
            this.config.setPoolName("MMO-hikari");
            String sb = "jdbc:mysql://" + cfg.getString("host", "localhost") + ":" + cfg.getString("port", "3306") + "/" + cfg.getString("database", "minecraft");
            this.config.setJdbcUrl(sb);
            this.config.setUsername(cfg.getString("user", "mmolover"));
            this.config.setPassword(cfg.getString("pass", "ILoveAria"));
            this.config.setMaximumPoolSize(cfg.getInt("maxPoolSize", 10));
            this.config.setMaxLifetime(cfg.getLong("maxLifeTime", 300000L));
            this.config.setConnectionTimeout(cfg.getLong("connectionTimeOut", 10000L));
            this.config.setLeakDetectionThreshold(cfg.getLong("leakDetectionThreshold", 150000L));
            if (cfg.isConfigurationSection("properties")) {
                for (String s : cfg.getConfigurationSection("properties").getKeys(false)) {
                    this.config.addDataSourceProperty(s, cfg.getString("properties." + s));
                }
            }
            this.dataSource = new HikariDataSource(this.config);
            this.load();
        }
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    protected abstract void load();

    public void getResult(String sql, Consumer<ResultSet> supplier) {
        this.execute(connection -> {
            try {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    supplier.accept(statement.executeQuery());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                statement.close();
            }
            catch (SQLException exception) {
                MythicLib.plugin.getLogger().log(Level.WARNING, "Could not open SQL result statement:");
                exception.printStackTrace();
            }
        });
    }

    public CompletableFuture<Void> getResultAsync(String sql, Consumer<ResultSet> supplier) {
        return CompletableFuture.runAsync(() -> this.getResult(sql, supplier));
    }

    public void executeUpdate(String sql) {
        this.execute(connection -> {
            try {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.executeUpdate();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                statement.close();
            }
            catch (SQLException exception) {
                MythicLib.plugin.getLogger().log(Level.WARNING, "Could not open SQL statement:");
                exception.printStackTrace();
            }
        });
    }

    public CompletableFuture<Void> executeUpdateAsync(String sql) {
        return CompletableFuture.runAsync(() -> this.executeUpdate(sql));
    }

    public void execute(Consumer<Connection> execute) {
        try {
            Connection connection = this.dataSource.getConnection();
            try {
                execute.accept(connection);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            connection.close();
        }
        catch (SQLException exception) {
            MythicLib.plugin.getLogger().log(Level.WARNING, "Could not open SQL connection:");
            exception.printStackTrace();
        }
    }

    public CompletableFuture<Void> executeAsync(Consumer<Connection> execute) {
        return CompletableFuture.runAsync(() -> this.execute(execute));
    }

    @Deprecated
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void close() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

