/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.parser.client.eval.DoubleEvaluator;
import io.lumine.mythic.lib.parser.client.math.ArithmeticMathException;
import io.lumine.mythic.lib.skill.SkillMetadata;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleFormula {
    @Nullable
    private final String value;
    private final double trivialValue;
    private final boolean trivial;
    public static final DoubleFormula ZERO = new DoubleFormula(0.0);

    public DoubleFormula(@NotNull String str) {
        boolean trivial;
        this.value = str;
        double trivialValue = 0.0;
        try {
            trivialValue = Double.valueOf(str);
            trivial = true;
        }
        catch (IllegalArgumentException exception) {
            trivial = false;
        }
        this.trivialValue = trivialValue;
        this.trivial = trivial;
    }

    public DoubleFormula(double trivialValue) {
        this.trivial = true;
        this.trivialValue = trivialValue;
        this.value = null;
    }

    public double evaluate(SkillMetadata meta) {
        try {
            return this.trivial ? this.trivialValue : Double.valueOf(new DoubleEvaluator().evaluate(meta.parseString(this.value)));
        }
        catch (ArithmeticMathException exception) {
            MythicLib.plugin.getLogger().log(Level.WARNING, "Could not evaluate '" + this.value + "' while casting skill '" + meta.getCast().getHandler().getId() + "': " + exception.getMessage());
            return 0.0;
        }
    }
}

