/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util.configobject;

import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.gson.JsonParser;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import java.util.Set;

public class JsonWrapper
implements ConfigObject {
    protected final JsonObject object;

    public JsonWrapper(JsonObject object) {
        this.object = object;
    }

    protected JsonWrapper(String value) {
        if (!value.contains("{") || !value.contains("}")) {
            this.object = new JsonObject();
            return;
        }
        int begin = value.indexOf("{");
        int end = value.lastIndexOf("}") + 1;
        this.object = new JsonParser().parse(value.substring(begin, end)).getAsJsonObject();
    }

    @Override
    public String getString(String key) {
        return this.object.get(key).getAsString();
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.object.has(key) ? this.getString(key) : defaultValue;
    }

    @Override
    public double getDouble(String key) {
        return this.object.get(key).getAsDouble();
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return this.object.has(key) ? this.getDouble(key) : defaultValue;
    }

    @Override
    public int getInt(String key) {
        return this.object.get(key).getAsInt();
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return this.object.has(key) ? this.getInt(key) : defaultValue;
    }

    @Override
    public boolean getBoolean(String key) {
        return this.object.get(key).getAsBoolean();
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.object.has(key) ? this.getBoolean(key) : defaultValue;
    }

    @Override
    public ConfigObject getObject(String key) {
        return new JsonWrapper(this.object.getAsJsonObject(key));
    }

    @Override
    public boolean contains(String key) {
        return this.object.has(key);
    }

    @Override
    public Set<String> getKeys() {
        return this.object.keySet();
    }
}

