/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.compatibility;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.variables.VariableManager;
import io.lumine.mythic.core.skills.variables.VariableScope;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlaceholderAPISupport
extends PlaceholderExpansion {
    private final MythicBukkit core;

    public PlaceholderAPISupport(MythicBukkit core) {
        this.core = core;
        this.register();
    }

    public String parse(String string) {
        return PlaceholderAPI.setPlaceholders(null, (String)string);
    }

    public String parse(String string, AbstractPlayer player) {
        return PlaceholderAPI.setPlaceholders((Player)((Player)player.getBukkitEntity()), (String)string);
    }

    public String onRequest(OfflinePlayer player, String identifier) {
        if (identifier.startsWith("var_")) {
            String entry;
            VariableManager manager = this.core.getVariableManager();
            String variablesIdentifier = identifier.substring(4);
            String[] fields = variablesIdentifier.split("_");
            String target = fields.length > 1 ? fields[0] : null;
            String string = entry = fields.length > 1 ? fields[1] : variablesIdentifier;
            if (target == null) {
                if (player != null && player.getPlayer() != null) {
                    AbstractPlayer abstractPlayer = BukkitAdapter.adapt(player.getPlayer());
                    return manager.getRegistry(VariableScope.CASTER, abstractPlayer).get(entry).toString();
                }
            } else {
                if (target.equalsIgnoreCase("WORLD") && player != null && player.getPlayer() != null) {
                    AbstractPlayer abstractPlayer = BukkitAdapter.adapt(player.getPlayer());
                    return manager.getRegistry(VariableScope.WORLD, abstractPlayer).get(entry).toString();
                }
                if (target.equalsIgnoreCase("GLOBAL")) {
                    return manager.getGlobalRegistry().get(entry).toString();
                }
                Player maybePlayer = Bukkit.getPlayer((String)target);
                if (maybePlayer != null) {
                    AbstractPlayer abstractPlayer = BukkitAdapter.adapt(maybePlayer);
                    return manager.getRegistry(VariableScope.CASTER, abstractPlayer).get(entry).toString();
                }
                try {
                    Entity maybeEntity = Bukkit.getEntity((UUID)UUID.fromString(target));
                    if (maybeEntity != null) {
                        AbstractEntity abstractEntity = BukkitAdapter.adapt(maybeEntity);
                        return manager.getRegistry(VariableScope.CASTER, abstractEntity).get(entry).toString();
                    }
                }
                catch (Exception e) {
                    MythicLogger.error("{0} is not a valid placeholder", identifier);
                }
            }
        }
        return null;
    }

    @NotNull
    public String getAuthor() {
        return "Ashijin";
    }

    @NotNull
    public String getIdentifier() {
        return "mythic";
    }

    @NotNull
    public String getVersion() {
        return "5.0.0";
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }
}

