/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.IDrop;
import io.lumine.mythic.api.mobs.GenericCaster;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.droppables.CustomDrop;
import io.lumine.mythic.core.drops.droppables.ItemDrop;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class BukkitMinecartChest
extends BukkitEntityType {
    private static final int height = 1;
    private String dropTable;

    @Override
    public void instantiate(MythicConfig mc) {
        this.dropTable = mc.getString("Options.ChestContents");
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.MINECART_CHEST, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        StorageMinecart minecart = (StorageMinecart)entity;
        if (this.dropTable != null) {
            this.fillChest((Entity)minecart, minecart.getInventory());
        }
        return minecart;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof StorageMinecart;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    private void fillChest(Entity cart, Inventory inventory) {
        AbstractEntity acart = BukkitAdapter.adapt(cart);
        DropMetadataImpl meta = new DropMetadataImpl(new GenericCaster(acart), acart);
        ArrayList items = Lists.newArrayList();
        MythicBukkit.inst().getDropManager().getDropTable(this.dropTable).get().generate(meta).getLootTable().forEach(type -> {
            IDrop drop;
            double amount = type.getAmount();
            if (type instanceof CustomDrop) {
                if (((CustomDrop)type).getDrop().isEmpty()) {
                    return;
                }
                drop = ((CustomDrop)type).getDrop().get();
            } else {
                drop = type;
            }
            if (drop instanceof ItemDrop) {
                items.add(BukkitAdapter.adapt(((ItemDrop)drop).getDrop(meta, amount)));
            }
        });
        for (ItemStack itemStack : items) {
            int slot = -1;
            while (inventory.getItem(slot = (int)(Math.random() * (double)inventory.getSize())) != null) {
            }
            int fslot = slot;
            inventory.setItem(fslot, itemStack);
        }
    }
}

