/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import io.lumine.mythic.bukkit.utils.config.ConfigurationSection;
import io.lumine.mythic.bukkit.utils.config.file.FileConfiguration;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.serialize.Chroma;

public class ColorProp
extends PropertyType<Chroma> {
    private final Chroma def;

    public ColorProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
        this.def = Chroma.of(255, 255, 255);
    }

    public ColorProp(LuminePlugin plugin, Object file, String node, Chroma def) {
        super(plugin, file, node);
        this.def = def;
    }

    @Override
    protected Chroma compute(ConfigurationSection section, String node) {
        if (section == null) {
            return this.def;
        }
        String prop = section.getString(node);
        if (prop == null) {
            return this.def;
        }
        try {
            return Chroma.of(prop);
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void set(String holder, Chroma value) {
        if (this.config == null) {
            return;
        }
        String val = value.serializeShortForm();
        if (holder != null) {
            this.config.set(holder + "." + this.node, val);
        } else {
            this.config.set(this.node, val);
        }
        try {
            ((FileConfiguration)this.config).save(this.plugin.getPropertyFile(this.file));
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
    }
}

