/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.http.client.methods;

import io.lumine.mythic.bukkit.utils.lib.http.ProtocolVersion;
import io.lumine.mythic.bukkit.utils.lib.http.RequestLine;
import io.lumine.mythic.bukkit.utils.lib.http.annotation.NotThreadSafe;
import io.lumine.mythic.bukkit.utils.lib.http.client.config.RequestConfig;
import io.lumine.mythic.bukkit.utils.lib.http.client.methods.AbstractExecutionAwareRequest;
import io.lumine.mythic.bukkit.utils.lib.http.client.methods.Configurable;
import io.lumine.mythic.bukkit.utils.lib.http.client.methods.HttpUriRequest;
import io.lumine.mythic.bukkit.utils.lib.http.message.BasicRequestLine;
import io.lumine.mythic.bukkit.utils.lib.http.params.HttpProtocolParams;
import java.net.URI;

@NotThreadSafe
public abstract class HttpRequestBase
extends AbstractExecutionAwareRequest
implements HttpUriRequest,
Configurable {
    private ProtocolVersion version;
    private URI uri;
    private RequestConfig config;

    @Override
    public abstract String getMethod();

    public void setProtocolVersion(ProtocolVersion version) {
        this.version = version;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.version != null ? this.version : HttpProtocolParams.getVersion(this.getParams());
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public RequestLine getRequestLine() {
        String method = this.getMethod();
        ProtocolVersion ver = this.getProtocolVersion();
        URI uriCopy = this.getURI();
        String uritext = null;
        if (uriCopy != null) {
            uritext = uriCopy.toASCIIString();
        }
        if (uritext == null || uritext.isEmpty()) {
            uritext = "/";
        }
        return new BasicRequestLine(method, uritext, ver);
    }

    @Override
    public RequestConfig getConfig() {
        return this.config;
    }

    public void setConfig(RequestConfig config) {
        this.config = config;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public void started() {
    }

    public void releaseConnection() {
        this.reset();
    }

    public String toString() {
        return this.getMethod() + " " + this.getURI() + " " + this.getProtocolVersion();
    }
}

