/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.http.impl.io;

import io.lumine.mythic.bukkit.utils.lib.http.Header;
import io.lumine.mythic.bukkit.utils.lib.http.HeaderIterator;
import io.lumine.mythic.bukkit.utils.lib.http.HttpException;
import io.lumine.mythic.bukkit.utils.lib.http.HttpMessage;
import io.lumine.mythic.bukkit.utils.lib.http.annotation.NotThreadSafe;
import io.lumine.mythic.bukkit.utils.lib.http.io.HttpMessageWriter;
import io.lumine.mythic.bukkit.utils.lib.http.io.SessionOutputBuffer;
import io.lumine.mythic.bukkit.utils.lib.http.message.BasicLineFormatter;
import io.lumine.mythic.bukkit.utils.lib.http.message.LineFormatter;
import io.lumine.mythic.bukkit.utils.lib.http.params.HttpParams;
import io.lumine.mythic.bukkit.utils.lib.http.util.Args;
import io.lumine.mythic.bukkit.utils.lib.http.util.CharArrayBuffer;
import java.io.IOException;

@NotThreadSafe
public abstract class AbstractMessageWriter<T extends HttpMessage>
implements HttpMessageWriter<T> {
    protected final SessionOutputBuffer sessionBuffer;
    protected final CharArrayBuffer lineBuf;
    protected final LineFormatter lineFormatter;

    @Deprecated
    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter, HttpParams params) {
        Args.notNull(buffer, "Session input buffer");
        this.sessionBuffer = buffer;
        this.lineBuf = new CharArrayBuffer(128);
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
    }

    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter) {
        this.sessionBuffer = Args.notNull(buffer, "Session input buffer");
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    protected abstract void writeHeadLine(T var1) throws IOException;

    @Override
    public void write(T message) throws IOException, HttpException {
        Args.notNull(message, "HTTP message");
        this.writeHeadLine(message);
        HeaderIterator it = message.headerIterator();
        while (it.hasNext()) {
            Header header = it.nextHeader();
            this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
        }
        this.lineBuf.clear();
        this.sessionBuffer.writeLine(this.lineBuf);
    }
}

